var PendingAttendanceGridProgramWise= Ext.create('Academia.store.attendance.PendingAttendanceGridStore');


Ext.define('Academia.view.attendance.pendingattendance.PendingAttendanceGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.pendingattendancegrid',
	store : PendingAttendanceGridProgramWise,
	title : getProgramandcourseTranslation('PENDING_ATTENDANCE_REPORT'),
	border: true,
	refreshStoreData:true,
	deferEmptyText: false,
	hidden:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	tbar:[],
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		itemId:'dockedItemsItemId',
		items : [ {
		      xtype: 'custompagingtoolbar',
	          plugins:['pagesize'],
			store : PendingAttendanceGridProgramWise,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	initComponent: function() {

        var grid=this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     

 },
	columns : [{
		header :getCommonTranslation('PROGRAM_GROUP'),
		dataIndex : 'groupName',
		hidden:true,
		flex : 1,
		sortable : true
	},{
		header :getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1,
		sortable : true
	}, {
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1,
		sortable : true
	}, {
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('DATE'),
		dataIndex : 'date',
		sortable : true,
		renderer: function(date) {
            return dateRender(date);
        }
	},{
		header : getCommonTranslation('COURSE'),
		dataIndex : 'courseName',
		flex : 1,
		sortable : true,
		hidden:true
	},{
		header : getCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVaraintName',
		flex : 1,
		sortable : true,
		hidden:true
	},{
		header : getCommonTranslation('FACULTY'),
		dataIndex : 'facultyName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('TOTAL_DAYS'),
		dataIndex : 'totalSession',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('ATTENDANCE_MARKED'),
		dataIndex : 'totalMarkedAttendance',
		flex : 1,
		sortable : true,
		hidden:true,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getCommonTranslation('ATTENDANCE_PENDING'),
		dataIndex : 'totalPendings',
		flex : 1,
		sortable : true,
		hidden:true,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	}]

});
