/**
 * The panel to contain all the pages of the application
 */
Ext.define('Academia.view.baselayout.contentarea.ContentPanel', {
    extend: 'Ext.tab.Panel',
    alias: 'widget.contentpanel',
    xtype: 'contentPanel',
    plain: true,
    border: true,
    autoScroll: false,
    cls:'horizontal-scrolling-fix contentPanel',
    requires: ['Ext.ux.TabCloseMenu'],
    layout: {
	type: 'fit',
	//align: 'stretch'
	//width:'100%'
    },
   // style:{ paddingLeft: '12px !important'},
    margin:'5px 0px 0px',
    //bodyPadding: '10',
    constructor:function() {
	this.callParent(arguments);
    },
    items: [],
    defaults: {
    	listeners: {
    		afterrender: function () {
    			var btnItemIds = ['#btnExportToPDF', '#btnExportToExcel', '#exportToPdfBtn', '#exportToPdfBtn', '#btnExportToPDFJasper', '#btnExportToExcelJasper', '#spBtnMoreActions'];
    			var moreActionBtnItemIds = ['spBtnMoreActionsAssessmentEvent','spBtnMoreActionsSJ'];
    			var contentPanel = this;
    			window.addEventListener("wheel", function(event) {
    				/*var btnArray = ['btnExportToPDF', 'exportToPdfBtn', 'btnExportToExcel'];
    				btnArray.forEach(function(btn) {
    					var exportToPdfBtn = Ext.ComponentQuery.query('#exportToPdfBtn');
    					exportToPdfBtn.forEach(function(btn) {
    						if(btn.menu && btn.menu.isVisible()) {
    							btn.menu.hide();
    							btn.blur();
    						}
    					});
    				});*/
    				for(var i = 0; i < btnItemIds.length; i++) {
    					//var exportBtn = Ext.ComponentQuery.query(btnItemIds[i]);
    					var exportBtn = contentPanel.query(btnItemIds[i]);
    					exportBtn.forEach(function(btn) {
    						if(btn && btn.menu && btn.menu.isVisible()) {
    							btn.menu.hide();
    							btn.blur();
    						}
    					});
    				}
    				for(var j = 0; j < moreActionBtnItemIds.length; j++) {
    					var moreActionBtn = contentPanel.query('#' + moreActionBtnItemIds[j]);
    					moreActionBtn.forEach(function(btn) {
    						if(btn && btn.menu && btn.menu.isVisible()) {
    							btn.menu.hide();
    							btn.blur();
    						}
    					});
    				}
    				if(event && event.target && event.target.parentElement && event.target.parentElement.className && Ext.isArray(event.target.parentElement.className) && event.target.parentElement.className.indexOf('x-boundlist') == -1 && event.target.parentElement.className.indexOf('x-list-plain') == -1){
                        var boundListArray = Ext.query('.x-boundlist');
                        Ext.each(boundListArray, function(currentBountList){
                            if(currentBountList && currentBountList.id && Ext.getCmp(currentBountList.id) && Ext.getCmp(currentBountList.id).isVisible()){
                                if(!Ext.getCmp(currentBountList.id).up('itemselector')){
                                		Ext.getCmp(currentBountList.id).hide();
                                }
                                
                            }
                        })
                    }
    				try {
    					if(contentPanel.up() && contentPanel.up().getActiveTab() && contentPanel.up().getActiveTab().down('grid')) {
    						var grids = contentPanel.up().getActiveTab().query('grid');
    						Ext.each(grids, function(grid) {
    							if(grid.headerCt.getMenu()) {
    								grid.headerCt.getMenu().hide();
    							}
    						});
    					}
    				}
    				catch(err) {
    					console.log(err);
    				}
    			});
    	    },
    	    close:function(cmp){
    	    	try{
    	    		cmp.up().getActiveTab().scrollBy(1,1);
    	    	}catch(e){}
    	    }
    	},
	    	tabchange:function(tabPanel){
	    		try{
	    			tabPanel.getActiveTab().scrollBy(1,1);
	    		}catch(e){}
	    	}
    },
    plugins: Ext.create('Ext.ux.TabCloseMenu', {
        
        listeners: {
            beforemenu: function (menu, item) {
                // Add a custom cls to the menu
                menu.addCls('contentPanelMenuCls');
            }
        }
    }),
    listeners: {
        beforeremove: function (ct, cmp) {
        	
        	if (cmp.xtype == 'dashboardhomepage'){
        		return false;
        	}
        	
        	//-- code for not closing first tab for applicant portal
            if(cmp.xtype=='applicantprofile' && portalId==6)
            {
                return false;
            }
        },
        tabchange: function (pnl) {
            try {
                var activeTab = pnl.getActiveTab();

                if (activeTab.xtype === 'personinfostudentportal') {
                    if (activeTab.down('trackrequestpanel')) {
                        var structure = activeTab;
                        structure.body.scrollBy(0, 1);
                        structure.body.scrollBy(0, -1);
                    }
                } else if (activeTab.xtype === 'studentprofileviewstructure') {
                    Ext.defer(function () {
                        var recentVisitedPanel = activeTab.down('recentvisitedstudentprofile');
                        if (recentVisitedPanel) {
                            var dataView = recentVisitedPanel.down('dataview');
                            if (dataView) {
                                dataView.getStore().reload({
                                    callback: function () {
                                        var storeDataLength = dataView.getStore().getCount();
                                        var profileTitle = recentVisitedPanel.title.split("(")[0].trim();
                                        if (storeDataLength > 0) {
                                            recentVisitedPanel.setTitle(profileTitle + " (" + storeDataLength + ")");
                                        } else {
                                            recentVisitedPanel.setTitle(profileTitle); // remove count if 0
                                        }
                                    }
                                });
                            }
                        }
                    }, 300); // Delay to allow components to fully render
                
                } else if (activeTab.xtype === 'userprofilestructure') {
                    Ext.defer(function () {
                        var recentVisitedPanel = activeTab.down('recentvisitedprofile');
                        if (recentVisitedPanel) {
                            var dataView = recentVisitedPanel.down('dataview');
                            if (dataView) {
                                dataView.getStore().reload({
                                    callback: function () {
                                        var storeDataLength = dataView.getStore().getCount();
                                        var profileTitle = recentVisitedPanel.title.split("(")[0].trim();
                                        if (storeDataLength > 0) {
                                            recentVisitedPanel.setTitle(profileTitle + " (" + storeDataLength + ")");
                                        } else {
                                            recentVisitedPanel.setTitle(profileTitle); // remove count if 0
                                        }
                                    }
                                });
                            }
                        }
                    }, 300); // Delay to allow components to fully render
                }
            } catch (e) {
                console.error('Tab change error:', e);
            }
        }

    }
});
