/**
 * @author Amit G
 *  
 * List of Activity Feeds screen.
 * 
 */
Ext.define('Academia.view.baselayout.header.ActivityFeedTypeGridForApplicant', {
	extend: 'Ext.grid.Panel',
    alias: 'widget.activityfeedtypegridforapplicant',
    title: getCommonTranslation('LIST_OF_ACTIVITY_FEEDS'), //List of Activity Feeds	    
    border: true,
    store: 'authentication.AllNotificationForApplicantStore',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },    
    /*initComponent: function() {    	
    	var grid=this; 
     	var store=Ext.create('Academia.store.authentication.ActivityFeedList');
     	Ext.apply(this, {
     		selModel:Ext.create('Ext.selection.CheckboxModel',{            	
        		checkOnly: true,
        	    mode: 'multi'
            }),
            store: store        
         });
         this.callParent(arguments);
         var custompagingtoolbar=grid.down('custompagingtoolbar');
         if(custompagingtoolbar){
         	custompagingtoolbar.bindStore(store);        	
         }
     },*/
    columns: [/*{    	
        dataIndex: 'imageUrl',
        flex: .1,
        hidden:true
    },*/ {    	
    	header:getCommonTranslation('SUBJECT'), //Subject
        dataIndex: 'subject',
        flex: .2,
        minWidth:200,       
        renderer: function(value,metaData,record) {
        	value = '<div class="containerBox">'
  				+ '<div class="avtar-containerBox" style="vertical-align: middle;border-radius: 100%;border: 1px solid #ccc;width: 45px;text-align: center;height: 40px!important;line-height: 3;">'
  				+'<img src="resources/images/notification_type.svg" width="20" alt="">'
  				+'</div>'
  				+'<div class="student-name" style="vertical-align: middle; width: 150px;"> '+value+'</div>'
  				+ '</div>'	
  				return value;
        }
    }, {
    	header:getCommonTranslation('CONTENT'), //Content
        dataIndex: 'msgContent',
        flex: 1,           
        renderer: function(value,metaData,record) {
        	//metaData.tdAttr = 'data-qtip="' + value + '"';
        	var regex = /(<([^>]+)>)/ig;
        	var result = value.replace(regex, "");
        	result = result.replace("&nbsp;", " ");
        	result = result.trim();
        	 
        	if(!isNullOrEmpty(result) && (!isEmpty(record.data) && !record.get("whetherRead"))){
        		result="<a href='#'><b>"+result+"</b></a>";
        	}else if(!isNullOrEmpty(result) && (!isEmpty(record.data) && record.get("whetherRead"))){
        		result="<a href='#'>"+result+"</a>";
        	}else if(!isNullOrEmpty(result)){
        		result="<a href='#'>"+result+"</a>";
        	}else if(isNullOrEmpty(result) && (!isEmpty(record.data) && !record.get("whetherRead"))){
        		result="<a href='#'><b>"+"Click here to see message"+"</b></a>";
        	}else{
        		result="<a href='#'>"+"Click here to see message"+"</a>";
        	}            	   
            return result;
        }
    }, {            	
    	header:getCommonTranslation('TIMING'), //Timing
        dataIndex: 'creationTime',
        flex: .12,
        minWidth:200,      
        renderer: function(value,metaData,record) {
        	if(!isNullOrEmpty(value) && (!isEmpty(record.data) && !record.get("whetherRead"))){
        		value="<b>"+value+"</b>";
        	}            	   
            return value;
        }        
    }],  
    tbar: [/*{
       // Hide button as per discussion with @mrinal
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'), //Delete Activity Feed
        glyph: ICONGLYPH.DELETEGLYPH        
    }*/],
    dockedItems: [{
        xtype: 'toolbar',
       // hidden:true,
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            displayInfo: true,
            store: 'authentication.AllNotificationForApplicantStore',
            emptyMsg: getCommonTranslation('EMPTY_ACTIVITY_FEED_LIST') //No activity feed list to display
        }]
    }]
});
