/**
 * @author prathamesh.sheth
 * 
 * show list of notification/alert in notification window.
 *    
 */
Ext.define('Academia.view.baselayout.header.NotificationAlertTemplate', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.notificationalerttemplate',        
    cls: 'notificationBodyPanelCls',
    initComponent: function() {
    	var me = this;
    	var nums = 0;
    	
    	var tpl = new Ext.XTemplate(
    			'<tpl for=".">',
					'<tpl if="this.shouldRender(xindex)">',
						'<div style="padding: 12px 16px 12px 24px !important;" class="thumb-wrap-new">',
							'<tpl if="whetherRead == false">',
								'<div class="notificationSubjectCls"><b>{subject}</b></div>',
								'<div class="notificationTimeCls"><b>{creationTime}</b></div>',
							'<tpl else>',
								'<div class="notificationSubjectCls">{subject}</div>',
								'<div class="notificationTimeCls">{creationTime}</div>',
							'</tpl>',
						'</div>',
					'</tpl>',
				'</tpl>',
    			{
    				// Template function to only render first 8 records
    				shouldRender: function(xindex) {
    					return xindex <= 8;
    				}
    			}
    	);

        var dataView = Ext.create('Ext.view.View', {
            autoScroll: true, // Allow scroll for more than 8
            cls: 'customized',
            itemId: 'NotificationAlertTemplateView',
            itemSelector: 'div.thumb-wrap-new',
            emptyText: '<div class="x-grid-empty NotificationAlertTemplateCls">' + getCommonTranslation('NODATADISPLAYMSG') + '<div>',
            tpl: tpl
        });
        
        
        if(portalId == 6){
        	var newStore = Ext.getStore('authentication.NotificationAlertForApplicantPortalList');
        }
        else{
        	var newStore = Ext.getStore('authentication.NotificationAlertList');
        }
        
        newStore.on('load', function(){
        	nums = Math.min(newStore.getCount(), 8);
        	if(nums = 0){
        		nums = 1;
        	}
        	me.height = 62*nums;
            me.autoScroll = false; // Ensure panel scrolls if content exceeds
        });

        this.items = [dataView];
        this.callParent(arguments);
    }
});