/**
 * @author prathamesh.sheth
 *  
 * Notification/Alert window screen.
 * 
 */	   
Ext.define('Academia.view.baselayout.header.NotificationAlertWindow', {
	extend : 'Ext.window.Window',
	alias : 'widget.notificationalertwindow',
	id:'NotificationAlertWindow',
	header: false,
	resizable:false,
	minHeight: 170,
	maxHeight: 620,
	bodyStyle: {
		margin: '0',
		padding: '0px !important',
		background:'#fff'
	},
	border:true,
	width: 400,
	items: [{
		xtype:'fieldcontainer',
		layout:'hbox',
		itemId:'notificationId',
		width:'100%',
		cls: 'notificationHeaderFCCls',
		style:{'border-bottom':'1px solid #ddd'},
		items:[{
			xtype:'component',					
			itemId : 'headerRegion',
			width: 400,
			region:'north',
			style:{
				display:'table'
			},
			renderTpl: ['<div class="notificationHeaderCls" style="display:table-cell;vertical-align:middle;text-align:left;text-decoration:none;"><div style="padding: 12px 16px 12px 24px;"><span>{unreadCount}</span><span style="margin-left: 2px;">{type}</span></div></div>'],
			data: {
				type:'',
				unreadCount: "0"
			},				
			renderSelectors: {
				spanEl1: 'span',
				spanEl2: 'span[style]'
			},				
			childEls: ["unreadCount"]

		}]
	},{
		xtype:'fieldcontainer',
		itemId: 'notificationTemplateFC',
		cls:'horizontalScrollingFixed',
		itemId:'alertId',
		height:'auto',
		width:'auto',
		minHeight: 62,
		defaults: {
			width: 400
		},
		items:[
			{
				xtype:'notificationalerttemplate',            
				itemId : 'notificationAlertTemplateRegion',
			}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		cls: 'notificationFooterCls',
		minHeight:53,
		items:[{
			xtype:'button',					
			itemId:'viewAllSection',
			cls: 'viewAllNotificationsBtn',
			width: '100%',
			text:getCommonTranslation('VIEW_ALL_NOTIFICATIONS_EMAIL')
		}]
	}]
});