/**
 * @author Akshay.Kalbhor
 * refers to the center north portion of the header which contains the notifications alerts and new Tasks button.
 */
Ext.define('Academia.view.baselayout.header.NotificationSection', {
	extend: 'Ext.Container',
	alias: 'widget.notificationsection', // for referring to this component using xtype
	bodyCls :'navbar navbar-default',
	baseCls:'x-plain',


	initComponent: function() {
		this.layout = {
				type: 'hbox',
				pack: 'end',
				align: 'auto'
		};

		this.items = [{
			 	xtype: 'label',
		        itemId: 'userNameItemId',
		        cls:'userNameItemIdClsName',
		        hidden: true,
		        style: {
		            'color':'white',
		            //'font-size': '14px',
		            'margin-top' : '20px',
		            'margin-left' : '5px',
		           	//'margin-right':'55px'
		        },
		       // text: ''
			
		}, {
			xtype: 'customcombobox',        
			itemId: 'cmbGlobalAcademyLocation',
			fieldLabel: getCommonTranslation('ACADEMY_LOCATION'), //Academy Location
			store: 'scholarships.LogedInUserAcademyLocationStore',	    
			valueField: 'id',
			displayField: 'academyLocationName',
			emptyText:getCommonTranslation('SELECT_ACADEMY_LOCATION'), //Select Academy Location
			editable: false,	    
			queryMode: 'local',	    
			triggerAction: 'all',
			labelAlign:'top',
			hidden: true,
			cls: 'headerComboBox',
			style:{
				marginRight:'10px',
				marginBottom:'10px'
			},
			forceSelection: true
		},{
			xtype:'component',

			itemId:'alertDiv',
			hidden:true,
			
			/**Old renderTpl
			 <div class="dropdown left alert-tag" style="width: 30px;"> <a class="dropdown-toggle head-button-link notification" data-toggle="dropdown"',
	            'href="#"><span class="notice-alert">{unreadCount}</span> <span class="notice-tag"></span> </a></div>
			****/
			renderTpl: ['<div class="dropdown left alert-tag" style="width: 30px;"> <a class="dropdown-toggle head-button-link notification" data-toggle="dropdown"',
			            'href="#"><span class="notice-alert">{unreadCount}</span> </a></div>'],

			            renderData: {
			            	type:'',
			            	unreadCount: "0"
			            },

			            renderSelectors: {
			            	spanEl: 'span'
			            },

			            childEls: ["unreadCount"]
		},
		{
		    xtype: 'component',
		    itemId: 'academiaAILogoId',
		    width: 40,
		    height: 40,
		    margin: '2 4 0 0',
		    cls: 'recentActivityV1',
		    style: {
		        'background-image': 'url(resources/images/headerLogo/Academia-AI-Icon-Logo.svg)',
		        'background-repeat': 'no-repeat',
		        'background-position': '2px center',
		        'background-size': '40px 40px'
		    },
		    listeners: {
		        afterrender: function (cmp) {
		            cmp.getEl().dom.setAttribute('data-qtip', 'Academia AI');
		        }
		    }
		},{
			xtype:'component',
			itemId:'notificationDiv',
			width: 40,
			height: 40,
			margin: '2 0 0 0',
			/**div class="dropdown left" style="height: 60; width: 90px;**/			
			 tpl:  new Ext.XTemplate('<tpl><div class="dropdown left recentActivityV1" style="height: 35px; width: 35px; border-radius: 100px;"> <a class="dropdown-toggle head-button-link ph ph-bell" data-toggle="dropdown"',
			'href="#"> </a><span id="notice-new" class="notice-new">{unreadCount}</span> </div></tpl>'),
			data: {
				type:'',
				unreadCount: "0"
			},
			renderSelectors: {
				spanEl: 'span'
			},	
			childEls: ["unreadCount"]
		},{
		    xtype: 'container',
            width: 40,
			height: 40,
			hidden: true,
			margin: '2 0 0 4',
		    layout: {
		        type: 'hbox',
		        align: 'middle'
		    },
		    items: [
		        {
		            xtype: 'component',
		            hidden: true,
		            width: 40,
					height: 40,
		            itemId: 'notificationRecentActivityAlertBox',
		            tpl: new Ext.XTemplate(
		                '<tpl>',
		                    '<div class="dropdown left recentActivity" style="height: 35px; width: 35px; margin-top: -5px; border-radius: 100px;">',
		                        '<a class="dropdown-toggle head-button-link-to-recent-activity" data-toggle="dropdown" href="#">',
		                            '<span class="notice-tag"></span>',
		                        '</a>',
		                    '</div>',
		                '</tpl>'
		            ),
		            data: {
		                type: '',
		                unreadCount: "0"
		            },
		            renderSelectors: {
		                spanEl: 'span'
		            }
		        },
		        {
		            xtype: 'component',
		            itemId: 'anotherNotificationIcon',
		            cls:'anotherNotificationIconCls',
		            tpl: new Ext.XTemplate(
		                '<tpl>',
		                    '<div class="dropdown left">',
		                        '<a href="#"><span class="second-notice-tag"></span></a>',
		                    '</div>',
		                '</tpl>'
		            ),
		            data: {
		                type: '',
		                unreadCount: "0"
		            },
		            renderSelectors: {
		                spanEl: 'span'
		            }
		        }
		    ]
		}
,{
			xtype:'component',

			itemId:'newTaskDiv', 

			renderTpl: ['<div class="dropdown left"> <a class="dropdown-toggle head-button-link tasks-alert config" data-toggle="dropdown"',
			            'href="#"> <!--span class="notice-new">{unreadCount}</span--> <span class="notice-tag" style="  margin-top: 23px; padding-left: 5px; padding-right: 5px; width: 70px;">New Tasks</span> </a> </div>'],
			            renderData: {
			            	type:'',
			            	unreadCount: "0"
			            },

			            renderSelectors: {
			            	spanEl: 'span'
			            },

			            hidden:true,

			            childEls: ["unreadCount"]
		}];

		this.callParent();
	}
});
