/**
 * @author Akshay.Kalbhor
 * refers to the center north portion of the header which contains the notifications alerts and new Tasks button.
 */
Ext.define('Academia.view.baselayout.header.UserInfo', {
    extend: 'Ext.Container',
    alias: 'widget.userinfo',
    bodyCls :'navbar navbar-default',
    baseCls:'x-plain',
    initComponent: function() {
	this.layout = {
	               type: 'hbox',
	               pack: 'center',
	               align: 'center'
	           };

        this.items = [ {
        	/*xtype : 'component',        	
        	renderTpl : new Ext.Template([ '<div class="dropdown left profile"> <a class="dropdown-toggle" data-toggle="dropdown" href="#"><div class="profile-avatar"><img src="~/../resources/images/avatar1.png" alt=""></div><div class="profile-username">{username}</div><div class="profile-caret"> <span class="caret-img"></span></div></a></div>' ]),
        	renderData : {
        		username : ''
        	},
        	childEls : [ "username" ]
        	
        }, {*/
        	//TODO: refine the component
        	xtype: 'button',
        	iconCls: 'profile-avatar',
        	//icon: '~/../resources/images/avatar1.png',
        	itemId: 'userInfoButton',
        	cls:'headerUserinfoBtn',
        	height: 40,
        	width: 224,
        	style: {
        		marginTop:'4px',
        		backgroundImage: 'none'
        	},
        	menu: Ext.menu.Menu({
        	    width: 225,
        	    //height:282,
        	    cls: 'userInfoPanelCLS',

        	    // ⭐ ADD THIS LISTENERS BLOCK HERE ⭐
        	    listeners: {
        	        afterrender: function (menu) {

        	            var store = Ext.getStore('BuildInfoStore');

        	            // ⭐ If store doesn't exist yet, create it
        	            if (!store) {
        	                store = Ext.create('Academia.store.systemusage.BuildInfoStore');
        	            }

        	            var item = menu.down('#releaseNameValueItem');

        	            function applyValue() {
        	                var rec = store.first();
        	                if (rec) {
        	                    item.setText(rec.get('buildName'));
        	                }
        	            }

        	            // If XML already loaded
        	            if (store.getCount() > 0) {
        	                applyValue();
        	            } else {
        	                store.on('load', applyValue, null, { single: true });
        	            }
        	        }
        	    }
,

        	    items: [{
        	        itemId: 'myDashboard',
        	        cls: 'headerUserinfoOption',
        	        text: getCommonTranslation('MY_DASHBOARD')
        	    },{
        	        itemId: 'changePasswordLink',
        	        cls: 'headerUserinfoOption',
        	        text: getCommonTranslation('CHANGE_PASSWORD')
        	    },{
        	        text: getCommonTranslation('TRANSLATE_WITH_GOOGLE'),
        	        itemId: 'translateWithGoogle',
        	        cls: 'headerUserinfoOption'
        	    },{
        	        itemId: 'changeStudentLink',
        	        cls: 'headerUserinfoOption',
        	        text: getCommonTranslation('CHANGE_STUDENT')
        	    },{
        	        text: getCommonTranslation('CHANGE_ACADEMY_LOCATION'),
        	        itemId: 'changeAcademyLocOption',
        	        cls: 'headerUserinfoOption',
        	        hidden: true
        	    },{
        	        text: getCommonTranslation('CHANGE_PORTAL'),
        	        itemId: 'changePortal',
        	        cls: 'headerUserinfoOption'
        	    },{
        	        text: getCommonTranslation('SOCIAL_MAPPING'),
        	        itemId: 'socialMapping',
        	        cls: 'headerUserinfoOption',
        	        hidden: true
        	    },{
        	        text: getCommonTranslation('CHANGE_LANGUAGE'),
        	        itemId: 'changeLanguage',
        	        cls: 'headerUserinfoOption',
        	        hidden: true,
        	        listeners: {
        	            beforerender: function(item){
        	                if (Ext.getStore('common.ChangeLanguageStore').count() < 2) {
        	                    item.hide();
        	                }
        	            }
        	        }
        	    },{
        	        text: getCommonTranslation('RELEASE_NOTES'),
        	        itemId: 'releaseNote',
        	        cls: 'headerUserinfoOption',
        	        handler: function(btn){
        	            window.open('https://releases.academiaerp.com/release-notes/', '_blank');
        	        }
        	    },{
        	        text: getCommonTranslation('RELEASE_NAME'),
        	        itemId: 'releaseDetail',
        	        cls: 'headerUserinfoOption',
        	        handler: function(){
        	            Ext.create('Academia.view.securitysetup.ReleaseDetailWindow').show();
        	        }
        	    },

        	    // ⭐ THIS IS THE NEW SECOND LINE BELOW "RELEASE NAME" ⭐
        	    {
        	        xtype: 'menuitem',
        	        disabled: true,
        	        itemId: 'releaseNameValueItem',
        	        cls: 'releaseNameValueCls',
        	        text: ''   // dynamically filled later
        	    },

        	    {
        	        text: getCommonTranslation('LOGOUT'),
        	        itemId: 'logoutButton',
        	        cls: 'headerUserinfoOption logoutBtnCls'
        	    }]
        	})

        }, 
        /*{
            xtype: 'container', // New div added here
            itemId: 'additionalDiv',
            cls: 'additionalDivCls',           
            style: {
                marginLeft: '5px 0 0 6px',
                padding: '5px',
//                backgroundColor: 'red',
                borderRadius: '50px',
                width: '42px',
            	height: '42px'
            }
        }*/
        ];
        
        this.callParent();
    }
});