Ext.define('Academia.view.baselayout.megamenu.VerticalNavigationMenu', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.verticalNavigationMenu',
    id: 'menuHolder',
    cls: 'mymenu',
    hideHeaders: false,
    collapsible: true,
    animate: true,
    animCollapse: true,
    titleCollapse: true,
    overflowX: false,
    margin: '0',
    style: { 'z-index': '99' },
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
    items: [],
    initComponent: function() {
        this.loadComponent();
        this.callParent();
    },
    placeholder: {
        collapseDirection: 'left',
        titleCollapse: 'true',
        id: 'placeholderLbar',
        width: 60,
        listeners: {
            afterrender: function(panel) {
                setTimeout(function() {
                    applyMenuBottomBorder();
                    
                    // add gradients on collapsed placeholder as well
                    var el = panel.getEl();
                    el.appendChild({
                        tag: 'div',
                        cls: 'menu-top-gradient'
                    });
                    el.appendChild({
                        tag: 'div',
                        cls: 'menu-bottom-gradient'
                    });
                }, 1000);
            }
        }
    },
    loadComponent: function() {
        var this$ = this;
        var toggleCollapseTool = {
            xtype: 'verticalMenuCollapseIcon',
            itemId: 'menuTogglerItem',
            iconCls: 'ph ph-text-indent menuTogglerExpand',
            height: 65
        };
        var MegaMenuModel = Academia.model.menu.MegaMenuDataModel;
        var menuData = MegaMenuModel.menuData;
        this$.getPlaceholder().add(toggleCollapseTool);
        menuData.sort(function(a, b) {
            return a.displayOrder - b.displayOrder;
        });
        var itemsArray = new Array();
        Ext.each(menuData, function(record) {
            var menuItem = Ext.create('Academia.view.baselayout.megamenu.VerticalNavigationMenuButton');
            menuItem.initialize(record);
            itemsArray.push(menuItem);
            var menuComponent = Ext.create('Academia.view.baselayout.megamenu.VerticalMenuCollapseIcon');
            menuComponent.initialize(record);
            this$.getPlaceholder().add(menuComponent);
        });
        this$.items = itemsArray;
        setTimeout(function() {
            applyMenuBottomBorder();
        }, 500);
    },
    listeners: {
        afterrender: function (panel) {
            var el = panel.getEl();
            el.appendChild({
                tag: 'div',
                cls: 'menu-top-gradient'
            });
            el.appendChild({
                tag: 'div',
                cls: 'menu-bottom-gradient'
            });
        }
    }
});