/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.bulkdocumentupload.BDUUploadForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.bduuploadform',
    autoScroll: false,
    frame: false,
    standardSubmit: false,
    defaults: {
        width: 256,
        labelAlign: 'top'
    },
    items: [{
		xtype:'uploadoptionradiogroup',
		width: 300,
        margin: 0,
		itemId:'bDUListUploadOptionRadioGroupItemId'
	},{
        xtype: 'customcombobox',
        name: 'importUtilityMasterId',
        itemId: 'moduleName',
        store: 'importutility.ModuleName',
        fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
        valueField: 'id',
        displayField: 'value',
        typeAhead: true,
        forceSelection: true,
        allowBlank: false
    }, {
        xtype: 'filefield',
        ui: 'CustomBtnThird',
        width: 536,
        fieldLabel: getCommonTranslation('BDU_UPLOAD_CSV_FILE'),
        buttonText: getCommonTranslation('BROWSE_FILE'),
        itemId: 'uploadFileField',
        name: 'file',
        allowBlank: false,
        validateOnChange: true,
        listeners: {
            change: function(fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('BDU_UPLOAD_CSV_FILE'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
                    }
                }
            }
        }
    }, {
        xtype: 'filefield',
        ui: 'CustomBtnThird',
        width: 536,
        fieldLabel: getCommonTranslation('BDU_UPLOAD_ZIP_FILE'),
        buttonText: getCommonTranslation('BROWSE_FILE'),
        itemId: 'zipFileItemId',
        name: 'zipFile',
        allowBlank: false,
        validateOnChange: true,
        listeners: {
            change: function(fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    if (!isNullOrEmpty(extension) && extension.toLowerCase() == 'zip'/* || extension == 'rar'*/) {
                        var file = fileField.fileInputEl.dom.files[0];
                        var maxSizeInBytes = 100 * 1024 * 1024;
                        if (file && file.size > maxSizeInBytes) {
                            fileField.reset();
                            showWarningMessage(getCommonTranslation('BDU_UPLOAD_ZIP_FILE'),'Zip file size exceeds 100 MB. Please upload a smaller file.');
                        }
                    } else {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('BDU_UPLOAD_ZIP_FILE'), getCommonTranslation('BDU_PLEASE_UPLOAD_ZIP_FILE'));
                    }
                }
            }
        }
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            action: 'Submit',
            text: getCommonTranslation('UPLOAD'),
            formBind: true,
            itemId: 'uploadId',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            itemId: 'resetBtn',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});