/**
 * @author Saket.Puranik
 
 * This component is used for to show User grid.
 */
Ext.define('Academia.view.calendar.entitylist.UserGrid',
		{
			extend : 'Ext.grid.Panel',
			alias : 'widget.calenderusergrid',
			/* requires : [ ], */
			store : 'calendar.entitylist.UserStore',
			title : getCommonTranslation('USER_TITLE'),//Faculties
			collapsible:false,
			border: true,
			//autoScroll: true,
		    viewConfig: {
		        stripeRows: CONSTANTS.STRIPEROWS
		    },
			columns : [ {
				header : getCommonTranslation('USER_ID_HEADER'),//Faculty Id	
				dataIndex : 'id',
				align: 'center',
				sortable : false,	
			    flex : .2
			}, {
				header : getCommonTranslation('USER_NAME_HEADER'),//Faculty Name
				dataIndex : 'printName',	
				align: 'center',
				sortable : false,	
				flex : .4/*,
				renderer: function(value, metaData, record, row, col, store, gridView){
					if(!isEmpty(record)){
						var firstName = record.get("firstName");
						var lastName = record.get("lastName")
						value = firstName.concat(" ",lastName);
					}
				    return value;
				}*/
			}, {
				header : getCommonTranslation('DEPARTMENT_HEADER'),//Status
				dataIndex : 'department',
				align: 'center',
				sortable : false,	
				flex : .4,
				renderer : function(obj){
					return columnObjRender(obj,"value");
				}
			}, {
				header : getCommonTranslation('SUB_DEPARTMENT_HEADER'),//Academy Location
				dataIndex : 'subDepartment',	
				align: 'center',
				sortable : false,	
				flex : .4,
				renderer : function(obj){
					return columnObjRender(obj,"value");
				}			
			}],
						
			tbar : [{
				xtype: 'label',
				text: getCommonTranslation('CALENDAR_USER_GRID_TITLE'),
				style: 'font-weight:bold;'
			}],
			dockedItems : [ {
				xtype : 'toolbar',
				dock : 'bottom',
				items : [{
					xtype: 'custompagingtoolbar',
		            plugins:['pagesize'],
					store : 'calendar.entitylist.UserStore',
					emptyMsg : '<span id="userGridId" style="margin-top: 60px !important">'+ getCommonTranslation('EMPTY_USER_MESSAGE')+'</span>',//No faculty to display
					displayInfo : true
				} ]
			} , {
				 xtype : 'toolbar',
				 dock : 'top',
				 items : [{
						xtype : 'textfield',
						itemId : 'userNameId',
						name : 'userName',
						emptyText:'--User Name--'	
					}, {
			        	xtype:'customcombobox',
			        	store:'department.ParentDepartmentByAccesibleStore',
			        	displayField:'name',
			        	valueField:'id',
			        	itemId:'comboDepartment',
			    		editable:false,
			        	emptyText:'All Departments'	
			        }, {
			        	xtype:'customcombobox',
			        	store:'calendar.entitylist.filters.SubDepartmentFilterStore',
			        	displayField:'name',
			        	valueField:'id',
			        	itemId:'comboSubDepartment',
			        	emptyText:'--Select--',	
			    		editable:false
			        }]
			 }]
		});
