/**
 *  @author Amit G
 */

Ext.define('Academia.view.campaign.PAdmAcademyLocationGridWithCampaign', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.padmacademylocationgridwithcampaign',
	title : getCommonTranslation('ACADEMY_LOCATION'),
	store: 'campaign.pAdmCompaignALMappingStore',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	//autoScroll: true,
	//height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	border: true,
	tbar: [{
		xtype:'button',
		itemId: 'nextButton',
		text:getCommonTranslation('NEXT'),
		tooltip: getCommonTranslation('NEXT')
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'academylocationsearchcombo',
		itemId:'academylocationsearchcombo',
		store: 'common.AcademyLocationByName',
		valueField: 'id',
		displayField: 'value',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'name',
		queryMode: 'remote',
		width: 256,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		},
		style:{
			'margin-left':'10px !important'
		}
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY_LOCATION'),
//		translationKey:'ACADEMY_LOCATION',
		dataIndex : 'value',
		sortable: false,
		flex : 1	 
	},{
        header: getCommonTranslation('CAMPAIGN_CONTACT_PERSON'),
        dataIndex: 'contactPersonValue',
        flex: 0.7,
        sortable: false,
        editor: {
        	xtype: 'customcombobox',
        	name: 'contactPerson',
        	itemId: 'contactPersonItemId',
			store: 'campaign.UserByAcademyLocation',
			valueField: 'valueCode',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			minChars:3,
			allowBlank: false,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
            forceSelection:true,
            listeners: {
        		change: function(obj, record) {
        			var grid = obj.up('grid')
        			var selectedRecord = grid.getSelectionModel().getSelection()[0];
        			var academyLocationId =  selectedRecord.get("id");
        			var store = obj.getStore();
        			store.getProxy().extraParams = {
        				academyLocationId:academyLocationId
        			};
        		},
        		select: function(obj, record) {
        			var contactUserId = obj.getStore().findRecord('id', record[0].data.id, 0, false, true, true);
        			var grid = obj.up('grid')
        			var selectedRecord = grid.getSelectionModel().getSelection()[0];
        			var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id, 0, false, true, true);
        			recordToBeUpdated.set('userId',contactUserId.data.id);
        		}
        	},
			  listConfig: {
				  listeners: {
	        		beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
				  }
	            }
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
        		if(isArray(value)){
        			return value[0].data.valueCode;
        		}else{
        			return value;
        		}
        	}
        	else{
        		rec.tdCls = 'gridInputCustomStyle';
        		return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
	},{
		  header: getProgramandcourseTranslation('REMARKS'),
		  dataIndex: 'remarkValue',
		  flex:.75,
		  sortable: false,
		  getSortParam: Ext.emptyFn,
		  editor : {
			  xtype: 'textfield',
			  name: 'coverageRemarks',
			  itemId: 'coverageRemarksItemId',
			  maxLength:255
		  },
	        renderer: function(val, rec) {
	            if (isNullOrEmpty(val)) {
	                rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
	            } else {
	                return val;
	            }
	        }
	}],
	plugins: [
	    Ext.create('Ext.grid.plugin.CellEditing', {
	        clicksToEdit: 1
	    })
	]
});
