/**
 *  @author Amit G
 */

Ext.define('Academia.view.campaign.PAdmCampaignAlProgramGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.padmcampaignalprogramgrid',
	title : getCommonTranslation('PROGRAM'),
	store: 'campaign.StoCampaignMapALProgramList',
	selType:'checkboxmodel',
	refreshStoreData:true,
	selModel: {
		mode:'SIMPLE',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : false,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	cls: 'horizontalScrollGridManageCamp',
	autoScroll: false,
	height:450,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	border: true,
	tbar: [{
		xtype: 'button',
		text: getCommonTranslation('SUBMITKYS'),
		itemId: 'submitCampaignMapping',
		buttonAlign: 'left',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'programsearchcombo',
		itemId:'programsearchcombo',
		store: 'feeandpayment.ALProgramSearchCombo',
		valueField: 'id',
		displayField: 'value',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'programName',
		queryMode: 'remote',
		width: 256,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		},
		style:{
			'margin-left':'10px !important'
		}
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1	 
	}, {
        header: getCommonTranslation('CAMPAIGN_CONTACT_PERSON'),
        dataIndex: 'contactPerson',
        flex: 1,
        hidden:true
    }, {
        header: getCommonTranslation('REMARKS'),
        dataIndex: 'coverageRemarks',
        flex: 1,
        hidden:true
    }]
});