Ext.define('Academia.view.campaign.dashboard.AppointmentDashboardReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.appointmentdashboardreportgrid',
	store: 'dashboard.AppointmentDashboardReportStore',
	title: getAdmissionTranslation('APPOINTMENT_DASHBOARD'),
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'dashboard.AppointmentDashboardReportStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);
	},
	columns: [{
		header: getCommonTranslation('ENQUIRY_ID'),
		dataIndex: 'enqCode',
		flex: 1,
		sortable: true,
		renderer : function(value) {
			return '<a href="#">' + value + '</a>';
		}
	},{
		header: getCommonTranslation('ENQUIRY_DATE'),
		dataIndex: 'enquiryDate',
		flex: 1,
		sortable: true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header: getCommonTranslation('ENQUIRER_NAME'),
		dataIndex: 'enquirerName',
		flex: 1,
		sortable: true
	},{
		header: getCommonTranslation('ACADEMY'),
		dataIndex: 'academyLocationName',
		flex: 1,
		sortable: true
	},{
		header: getCommonTranslation('REGISTRATION_TYPE'),
		dataIndex: 'registrationTypeValue',
		flex: 1,
		sortable: true
	},{
		header: getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex: 1,
		sortable: true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
			rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 4;-webkit-box-orient: vertical;line-height: 22px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
			return val;
		}   
	},{
		header: getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex: 1,
		sortable: true
	},{
		header: getCommonTranslation('OWNER'),
		dataIndex: 'assignToUserName',
		flex: 1,
		sortable: true
	},{
		header: getAdmissionTranslation('ENQUIRY_STATUS_APPOINTMENT'),
		dataIndex: 'status',
		flex: 1,
		sortable: true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)){
				if(val == 'Open'){
					rec.style = 'color:green';
					return val;
				}else{
					rec.style = 'color:red';
					return val;
				}
			}else{
				return '';
			}
		}
	},{
		header: getAdmissionTranslation('ENQUIRY_STAGE_APPOINTMENT'),
		dataIndex: 'enquiryStage',
		flex: 1,
		sortable: true
	},{
		header: getCommonTranslation('PRIORITY'),
		dataIndex: 'enqPriorityName',
		flex: 1,
		sortable: true
	},{
		header:  getServiceRequestTranslation('APPOINTMENT_DATE'),
		dataIndex: 'appointmentDate',
		flex:1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('APPOINTMENT_COMPLETION_DATE_TIME'),
		dataIndex: 'appointmentCompletionDateTime',
		flex: 1,
		sortable:true,
		hidden:true,
		renderer:function(date) {
			return '<div>'+dateRender(date)+'</div>'+" "+'<div>'+timeRender(date)+'</div>';
		}
	},{
		header:  getAdmissionTranslation('APPOINTMENT_TYPE'),
		dataIndex: 'appointmenType',
		flex:1,
		sortable:true

	},{
		header:  getCommonTranslation('ADDITIONAL_VISIT_REASON'),
		dataIndex: 'additionalReasonToVisit',
		flex:1,
		hidden:true,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(val!=null){
				rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
				rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 15px;max-height: 55px;min-width: 10ch;max-width: 11ch;';
				return val;
			}
		}

	},{
		header:  getAdmissionTranslation('APPOINTMENT_OWNER'),
		dataIndex: 'appointmentOwner',
		flex:1,
		sortable:true

	},{
		header:  getAdmissionTranslation('APPOINTMENT_STATUS'),
		dataIndex: 'appointmentStatus',
		flex:1,
		sortable:true

	}]
});