/**
 * @author sumit.meena
 */
Ext.define('Academia.view.campaign.dashboard.CMPDasboardFilter', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.cmpdasboardfilter',
//    title: getCommonTranslation('FILTERS'),
    autoScroll: true,
    frame: false,
	cls:'customSearchPanel',
    method: 'POST',
    /*layout: {
        type: 'vbox'
    },*/
    standardSubmit: false,
    plugins:"formlabelrequired",
    isMinWidthNotRequired: true,
    defaults: {
        labelAlign: 'top',
        width: 256
    },
    items: [{
    	xtype: 'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 256,
			labelAlign:'top'
		},
        items: [{
        	xtype : 'textfield',
        	name : 'CAMPIAGN_ID',
        	fieldLabel : getCampaignTranslation('CAMPIAGN_ID')
        }, {
        	xtype : 'textfield',
        	name : 'CAMPIAGN_NAME',
        	fieldLabel : getCampaignTranslation('CAMPIAGN_NAME')
        }, {

			xtype : 'customcombobox',
			fieldLabel : getEnquiryTranslation('INTAKE_YEAR'),
			name : 'INTAKE_YEAR',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			width: 256,
			//typeAhead:true,
			forceSelection:true,
            editable: false,
			//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			//minChars:3,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store)
				}
			}
		
        }/*{
        	xtype: 'datefield',
            name: 'fromdate',
            itemId:'fromdateItemId',
            fieldLabel:getCampaignTranslation('FROM_DATE'),
            format: CONSTANTS.DATE_FORMAT,
	        submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
        	disabled: false,
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				}	
        },{
        	xtype: 'datefield',
            name: 'todate',
            itemId:'todateItemId',
            fieldLabel:getCampaignTranslation('TO_DATE'),
            format: CONSTANTS.DATE_FORMAT,
	        submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
	        disabled: false,
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				}	
        }*/]
    },{
    	xtype: 'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 256,
			labelAlign:'top'
		},
        items: [{
        	xtype: 'datefield',
            name: 'FROM_DATE',
            itemId:'fromdateItemId',
            vtype : 'daterange',
     	   	endDateField : 'todateItemId',
            fieldLabel:getCampaignTranslation('FROM_DATE'),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
//        	allowBlank : false,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				},
		        /*change: function(field, newValue, oldValue) {
		            var endDateField = field.up('form').down('#todateItemId');
		            endDateField.setMaxValue(newValue);
		        }*/
			}	
        },{
        	xtype: 'datefield',
            name: 'TO_DATE',
            itemId:'todateItemId',
            vtype : 'daterange',
     	    startDateField : 'fromdateItemId',
            fieldLabel:getCampaignTranslation('TO_DATE'),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
//        	allowBlank : false,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				},
		       /* change: function(field, newValue, oldValue) {
		            var startDateField = field.up('form').down('#fromdateItemId');
		            startDateField.setMaxValue(newValue);
		        }*/
			}	
        }]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtn',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true,
            margin: '0 44 0 0'
        },{
        	xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			listeners: {
                click: function(button, eOpts) {
                	this.up('form').getForm().reset();
                	var form = this.up('form');
                	
                	var startDateField = form.down('#fromdateItemId');
                    var endDateField = form.down('#todateItemId');
                    startDateField.setMaxValue(null);
                    endDateField.setMinValue(null); 
                }
            }
        }]
    }]
});