
Ext.define('Academia.view.campaign.dashboard.FollowUpDashboardGrid',{
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	title: getEnquiryTranslation('FOLLOWUP_DASHBOARD'),
	alias : 'widget.followupdashboardgrid',
	store: 'dashboard.FollowUpDashboardStore',
	border: true,
	frame: false,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'followupdashboardform':1
		}},
		dockedItems : [ {
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store:'dashboard.FollowUpDashboardStore',
				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}
		],
	   initComponent: function() {
	       var grid = this;
	       grid.addExportToolBarItems(grid, false);
	       this.callParent(arguments);
	   },
    columns: [{
        header: getCommonTranslation('ENQUIRY_ID'),
        dataIndex: 'enqCode',
        flex: 1,
        sortable: true,
        renderer : function(value) {
        	return '<a href="#">' + value + '</a>';
        	}
    },{
        header: getCommonTranslation('ENQUIRY_DATE'),
        dataIndex: 'enquiryDate',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('ENQUIRER_NAME'),
        dataIndex: 'enquirerName',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('ACADEMY'),
        dataIndex: 'academyLocationName',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('REGISTRATION_TYPE'),
        dataIndex: 'registrationType',
        flex: 1,
        sortable: true,
        renderer : function(value) {
        	if(!isNullOrEmpty(value))
        		{
        		if(value==false)
        			{
        			return 'Full Time';
        			}
        		else
        			{
        			return 'Part Time';
        			}
        		
        		}
        }
    },{
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('OWNER'),
        dataIndex: 'assignToUserName',
        flex: 1,
        sortable: true
    },{
        header: getAdmissionTranslation('ENQUIRY_STATUS_APPOINTMENT'),
        dataIndex: 'status',
        flex: 1,
        sortable: true,
        renderer:function(val,rec,record,rowIndex,colIndex,store,view){
            if(!isNullOrEmpty(val)){
            if(val == 'O'){
            rec.style = 'color:green';
            return getCommonTranslation("OPEN");
            }else{
            rec.style = 'color:red';
            return getCommonTranslation("CLOSED");;
            }
            }else{
            return '';
            }
           }
    },{
        header: getAdmissionTranslation('ENQUIRY_STAGE_APPOINTMENT'),
        dataIndex: 'enquiryStage',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('PRIORITY'),
        dataIndex: 'enqPriorityName',
        flex: 1,
        sortable: true
    },{
		header:  getServiceRequestTranslation('FOLLOW_UP_DATE'),
		dataIndex: 'actualFollowUpDate',
		flex:1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getEnquiryTranslation('REASON_FOR_FOLLOW-UP'),
		dataIndex: 'reasonForFollowUp',
		flex:1,
		sortable:true,
	},{
		header:  getEnquiryTranslation('FOLLOW_UP_ACTIVITY_STATUS'),
		dataIndex: 'followUpActivityStatus',
		flex:1,
		sortable:true
	},{
		header:  getEnquiryTranslation('FOLLOW_UP_STATUS_UPDATE_DATE_AND_TIME'),
		dataIndex: 'followupStatusUpdateAndTime',
		flex:1,
		sortable:true,
		hidden:true,
		renderer:function(date) {
            return '<div>'+dateRender(date)+'</div>'+" "+'<div>'+timeRender(date)+'</div>';
          }
	},{
		header:  getEnquiryTranslation('FOLLOW_UP_SCHEDULE'),
		dataIndex: 'followUpDate',
		flex:1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},
	{
		header:  getEnquiryTranslation('ADDITIONAL_REASON'),
		dataIndex: 'additionalReason',
		flex:1,
		sortable:true,
		hidden:true
		}]
    	});


