Ext.define('Academia.view.campaign.dashboard.SignUpReportFilter', {
	extend: 'Ext.form.FormPanel',
	alias : 'widget.signupreportfilter',
	//autoScroll: true,
	frame: false,
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	cls: 'customSearchPanel',
	plugins:"formlabelrequired",
	defaults: {
		labelAlign: 'top',
		// width: 256
	},
	items:[{
		xtype:'fieldcontainer',
		itemId: 'followupDetailsConatiner',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		style :{
			  marginLeft: '6px'
		},
			items:[{
				xtype: 'multiselectcombofield',
				width: 536,
				//height:58,
				name: 'multiselectAcademyLocation',
				itemId: 'academyLocationId',
				allowBlank : true,
				fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
				store:'user.UserAcademyLocationStore',
				displayField:'value',
				queryParam:'academyLocationId',
				valueField:'id',
				matchFieldWidth:true,
				maxLength:15000,
				queryMode:'local',
				cls:'commonAutoHeightMultiselectField',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			},{

				xtype: 'customcombobox',
				name:'signUpUserName',
				itemId:'signUpUserName',
				store:'Academia.store.signUpReport.SignUpUserStore',
				fieldLabel: getCommonTranslation('APPLICATION_ID_SIGNUP_USERNAME'),
				width: 256,
				valueField: 'id',
				displayField: 'value',
				queryParam:'applicantName',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
				triggerAction: '',
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            forceSelection:true,
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{code}/{printName}'  +
		                    '</div>';
		                }
		            }
			}]},{
				xtype:'fieldcontainer',
				layout: 'hbox',
				style: {
					//marginTop: '40px!important',
					marginLeft:'-0px !important'
				},
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				style :{
					  marginLeft: '6px'
				},
			items:[{
				xtype: 'datefield',
				name: 'fromdate',
				itemId:'fromdate',
				allowBlank : true,
				
				vtype: 'daterange',
				endDateField: 'todate',
				fieldLabel: getFeeAndPaymentCommonTranslation('FROM_DATE'),
				maxValue:new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				xtype: 'datefield',
				name: 'todate',
				itemId:'todate',
				allowBlank : true,
				vtype: 'daterange',
				startDateField: 'fromdate',
				fieldLabel: getCommonTranslation('TO_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
	        	xtype: 'checkboxfield',
	        	labelAlign: 'right',
	        	style:{
	        		marginTop:'25px'
	        	},
	        	itemId:'admSubmittedRecordsSignUpItemId',
	        	boxLabel: getCommonTranslation('SHOW_SUBMITTED_RECORDS'),
	        	name: 'showSubmissionRecord',
	        	width:240,
	        	inputValue : true
			}]},{
			    xtype: 'fieldcontainer',
		        width:'100%',
		        cls:'windowBtnPos',
		        layout : {
					type : 'hbox'
				},
				cls: 'customSearchPanelBtnsFieldContainerCls',
		        items: [{
		            xtype: 'button',
		            itemId:'searchBtn',
		            text: getCommonTranslation('SEARCH'),
		            ui: 'CustomBtnSubmit',
		            scale: CONSTANTS.BUTTONSIZE,
		            formBind:true
		        }, {
		            xtype: 'button',
		            text: getCommonTranslation('RESET'),
		            itemId:'resetBtn',
		            ui: 'CustomBtnCancel',
		            scale: CONSTANTS.BUTTONSIZE
		        }]}
]
			});