Ext.define('Academia.view.committee.committee.AddCommitteeMembershipWindow', {
	extend: 'Ext.window.Window',
	title:getCommonTranslation("ADD_MEMBERSHIP"),
	modal: true,
	autoScroll:true,
	resizable:false,
	height:465,
	width:'60%',
	alias: 'widget.addCommitteeMembershipWindow',
    items:[{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		defaults: {
			labelAlign: 'top'
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
    items: [{
    	xtype: 'hidden',
		itemId:'idItemId',
		name: 'id'
    },{
    	xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			flex:1
		},
		style: {
			marginLeft: '6px'
		},
		items: [{
            xtype: 'customcombobox',
            name: 'membershipType',
            itemId: 'membershipType',
            allowBlank:false,
            fieldLabel: getCommonTranslation("MEMBERSHIP_TYPE"),
            store: Ext.create('Academia.store.committee.committee.MembershipTypeStore'),
            valueField: 'id',
            displayField: 'value',
            matchFieldWidth:true,
            editable: false
        },{
            xtype: 'datefield',
            fieldLabel: getCommonTranslation("MEMBERSHIP_APPLICATION_START_DATE"),
            name: 'memberShipStartDate',
            itemId :'membershipStartDate',
            allowBlank : false,
            vtype: 'daterange',
			endDateField: 'membershipEndDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
        },{
            xtype: 'datefield',
            fieldLabel: getCommonTranslation("MEMBERSHIP_APPLICATION_END_DATE"),
            name: 'memberShipEndDate',
            itemId: 'membershipEndDate',
            vtype: 'daterange',
            allowBlank : false,
			startDateField: 'membershipStartDate',listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        }]
	},{
    	xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			flex:1
		},
		style: {
			marginLeft: '6px'
		},
		items: [{
			 xtype      : 'radiogroup',
			 fieldLabel : getCommonTranslation('ONLINE_APPLICATION_REQUIRED'),
			 itemId: 'onlineApplicationRequired',
			 name: 'onlineApplicationRequired',
			 allowBlank:false,
			 defaults: {
				 flex: 1
			 },
			 layout: 'hbox',
			 items:[{ 
				 boxLabel: getCommonTranslation('YES'), 
				 name: 'whetherOnlineApplicationRequired', 
				 inputValue: true
			 },{ 
				 boxLabel: getCommonTranslation('NO'), 
				 name: 'whetherOnlineApplicationRequired', 
				 inputValue: false,
				 checked:true
			 }]
		 },{
            xtype: 'datefield',
            fieldLabel: getCommonTranslation("APPLICATION_START_DATE"),
            name: 'applicationStartDate',
            itemId :'applicationStartDate',
            allowBlank : false,
            vtype: 'daterange',
            disabled:true,
			endDateField: 'applicationEndDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        },{
            xtype: 'datefield',
            fieldLabel:getCommonTranslation("APPLICATION_END_DATE"),
            name: 'applicationEndDate',
            itemId: 'applicationEndDate',
            vtype: 'daterange',
            disabled:true,
            allowBlank : false,
			startDateField: 'applicationStartDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        }]
	},{
    	xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			flex:1
		},
		style: {
			marginLeft: '6px'
		},
		items: [{
			 xtype      : 'radiogroup',
			 fieldLabel : getCommonTranslation('FEES_APPLICABLE'),
			 itemId: 'feesApplicable',
			 name: 'feesApplicable',
			 allowBlank:false,
			 defaults: {
				 flex: 1
			 },
			 layout: 'hbox',
			 items:[{ 
				 boxLabel: getCommonTranslation('YES'), 
				 name: 'whetherFeesApplicable', 
				 inputValue: true
			 },{ 
				 boxLabel: getCommonTranslation('NO'), 
				 name: 'whetherFeesApplicable', 
				 inputValue: false,
				 checked:true
			 }]
		 },{

	            xtype: 'customcombobox',
	            name: 'feePlan',
	            itemId: 'feePlan',
	            allowBlank:false,
	            fieldLabel: getCommonTranslation("FEE_PLAN"),
	            store: Ext.create('Academia.store.committee.committee.MembershipFeePlanTypeStore'),
				valueField: 'id',
				displayField: 'value',
				editable: false,
				typeAhead:true,
				forceSelection:true,
				disabled:true,
        },{
            xtype: 'customcombobox',
            name: 'feeRule',
            itemId: 'feeRule',
            allowBlank:false,
            fieldLabel: getFeeAndPaymentCommonTranslation("FEE_RULE"),
            store: Ext.create('Academia.store.committee.committee.MemebershipFeeRuleStore'),
            valueField: 'id',
            displayField: 'value',
            disabled:true,
            editable: false
           }]
	},{
    	xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		height: '',
		defaults: {
			labelAlign: 'top',
			flex: 1
		},
		style: {
			marginLeft: '6px'
		},
		items: [{
			 xtype      : 'radiogroup',
			 fieldLabel : getServiceRequestTranslation("AUTO_APPROVE"),
			 itemId: 'autoApprove',
			 name: 'autoApprove',
			 allowBlank:false,
			 defaults: {
				 flex: 1
			 },
			 layout: 'hbox',
			 items:[{ 
				 boxLabel: getCommonTranslation('YES'), 
				 name: 'whetherAutoApprove', 
				 inputValue: true,
				 checked:true
			 },{ 
				 boxLabel: getCommonTranslation('NO'), 
				 name: 'whetherAutoApprove', 
				 inputValue: false
			 }]
		 },{
				xtype: 'customcombobox',
				name: 'approverId',
				itemId: 'approverId',
				fieldLabel: getCommonTranslation('APPROVER'),
				valueField: 'id',
				displayField: 'value',
				store: Ext.create('Academia.store.committee.committee.MembershipApproverStore'),
	  			queryParam:'codeOrName',
	  			minChars:3,
	  			typeAhead:false,
	  			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	  			enableKeyEvents  : 'true',
	  			hideTrigger:false,
	  			allowBlank:false,
	  			forceSelection:true,
	  			disabled:true,
	  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				maxLength:100,
	  			listConfig: {
	  				listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	  				loadingText: getCommonTranslation('SEARCHING'),
	  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	  				getInnerTpl: function() {
	  					return '<div class="search-item">' +
	  					'{value}' +
	  					'</div>';
	  				}
	  			}
			},{
				xtype: 'checkboxfield',
				name: 'additionalMembership',
				itemId : 'additionalMembership',
				boxLabel: getCommonTranslation('ADDITIONAL_MEMBERSHIP'),
				inputValue: true,
				uncheckedValue: false,
				style:{
	        		marginTop:'25px'
	        	}
			}]
        },{
    		xtype:'fieldcontainer',
    		width:'100%',
    		items : [{
    			xtype : 'button',
    			text : getCommonTranslation('SAVE'),
    			itemId : 'saveMemebershipBtn',
    			ui : 'CustomBtnSubmit',
    			scale : CONSTANTS.BUTTONSIZE,
    			formBind : true
    		},{
    			xtype : 'button',
    			text : getCommonTranslation('CANCEL'),
    			itemId : 'cancelMemebershipBtn',
    			ui : 'CustomBtnCancel',
    			scale : CONSTANTS.BUTTONSIZE
    		}]
    	}]
    }]
});
    
    