Ext.define('Academia.view.committee.committee.AlumniCommitteeAddMappingProgramViewGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.alumnicommitteeaddmappingprogramviewgrid',
	title : getCommonTranslation('PROGRAM'),
	store: 'committee.committee.AlumniCommitteProgramMappingStore',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	 dockedItems: [{
	        xtype: 'toolbar',
	        dock: 'bottom',
	        items: [{
	            xtype: 'custompagingtoolbar',
	            plugins: ['pagesize'],
	            store: 'committee.committee.AlumniCommitteProgramMappingStore',
	            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
	            displayInfo: true
	        }]
	    }],
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	border: true,
	tbar: [{
		xtype:'button',
		itemId: 'nextButton',
		text:getAlumni('NEXT'),
		tooltip: getAlumni('NEXT')
	},{
		xtype: 'button',
		text: getAlumni('SUBMITKYS'),
		itemId: 'submitAlumniMapping',
		buttonAlign: 'left',
		scale: CONSTANTS.BUTTONSIZE,
		disabled: true,
	},{
		xtype: 'button',
		text: getAlumni('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'programsearchcombo',
		itemId:'programsearchcombo',
		//store: 'feeandpayment.ALProgramSearchCombo',
		store: 'committee.committee.AlumniCommitteProgramMappingStore',
		valueField: 'programId',
		displayField: 'programName',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'name',
		queryMode: 'remote',
		width: 256,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	}],
	columns: [{
		header : getAlumni('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1	 
	},{
		header : getAlumni('PROGRAM'),
		dataIndex : 'programName',
		flex : 1	 
	}]
});