/**
 * @author Harshit Satya
 * 
 */
Ext.define('Academia.view.committee.committee.AlumniInterestGroupForm',{
	extend:'Academia.view.common.DynamicFieldForm',
	alias : 'widget.alumniinterestgroupform',
	autoScroll: true,
	bodyPadding:'10 10 10 10',
	frame:true,
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	method: 'POST',
	defaults: {
		labelAlign: 'top',
	},
	plugins : "formlabelrequired",
	items : [{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'hidden',
			itemId:'idItemId',
			name: 'id'
		}, {
			xtype : 'textfield',
			name : 'committeeCode',
			itemId:'committeeCodeItemId',
			fieldLabel : getAlumni("COMMITTEE_CODE"),
			displayField: 'name',
            valueField: 'id',
			allowBlank:false,
			maxLength: 10
		},{
			xtype : 'textfield',
			name : 'committeeName',
			itemId:'committeeNameItemId',
			fieldLabel : getCommonTranslation("COMMITTEE_NAME"),
			displayField: 'name',
            valueField: 'id',
			allowBlank:false,
			maxLength: 45
		}]

	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'user',
			itemId: 'userItemId',
			fieldLabel: getCommonTranslation("COMMITTEE_CO_ORDINATOR"),
			valueField: 'committeeCoordinatorId',
			displayField: 'committeeCoordinatorName',
			valueField: 'id',
			store: 'committee.committee.CommitteeCoordinator',
  			queryParam:'codeOrName',
  			minChars:3,
  			typeAhead:false,
  			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
  			enableKeyEvents  : 'true',
  			hideTrigger:false,
  			allowBlank:false,
  			forceSelection:true,
  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			maxLength:100,
  			listConfig: {
  				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
  				loadingText: getCommonTranslation('SEARCHING'),
  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
  				getInnerTpl: function() {
  					return '<div class="search-item">' +
  					'{committeeCoordinatorCode}'+ ' / ' + '{committeeCoordinatorName}'+
  					'</div>';
  				}
  			}
		}, {
			xtype: 'customcombobox',
			name: 'committeeType',
			itemId: 'committeeTypeItemId',
			fieldLabel: getCommonTranslation("COMMITTEE_TYPE"),
			store: 'committee.committee.CommitteeType',
			displayField: 'value',
			valueField: 'id',
			forceSelection: true,
  			allowBlank:false,
  			editable: false,
  			listConfig: {
  				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
  			},
  			listeners: {
                afterrender: function (combo) {
                    combo.getStore().load();  // Trigger store load on combobox render
                }
            }
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		style:{
			marginTop:'22px',
			marginBottom:'15px'
		},
		defaults : {
			labelAlign : 'top'
		},
		items : [ {
			html: '<b><u>Validity</u></b>',
			margin: 0,
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
        	xtype: 'datefield',
            fieldLabel: getAlumni('START_DATE'),
            name: 'startDate',
            itemId: 'startDateItemId',
            format: 'd/m/Y',
            allowBlank:false,
            minValue: new Date(),
            listeners: {
                change: function(field, newValue) {
                    var endDateField = field.up('form').down('#endDateItemId');
                    if (newValue && endDateField) {
                        endDateField.setMinValue(newValue);  // Set the end date's minimum value based on start date
                    }
                }
            }
        },{
        	xtype: 'datefield',
            fieldLabel: getAlumni('END_DATE'),
            name: 'endDate',
            itemId: 'endDateItemId',
            allowBlank:false,
            format: 'd/m/Y',
            minValue: new Date(),
        }]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'status',
			itemId:'statusItemId',
			store:'common.StatusComboStore',
			displayField:'name',
			valueField:'id',
			value:'ACTIVE',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			fieldLabel:getCommonTranslation('STATUS'),
		}]
	},{
		xtype: 'fieldcontainer',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 536,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'textarea',
			name:'description',
			itemId:'descriptionId',
			width: 536,
			maxLength : 255,
			fieldLabel: getExaminationTranslation('Description')
		}]
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'hbox'
		},
		width:'auto',
		items : [{
			xtype : 'button',
			text : getCommonTranslation("SAVE") ,
			itemId : 'submitBtnAl',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			itemId: 'resetBtnAl',
			text: getCommonTranslation("RESET"),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
		}]
	}]
});
