/**
 * @author priyanshi sharma
 * 
 */
Ext.define('Academia.view.committee.committee.CommitteApplyToGridForCourseSection', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.committeapplytogridforcoursesection',
	store : 'committee.committee.CommitteeApplyToGridStore',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'committee.committee.CommitteeApplyToGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns : [{
		header:  getCommonTranslation("ACADEMIC_TERM"),
		dataIndex: 'academicTerm',
		flex:1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return value.value;
			}
		}
	},{
		header : getCommonTranslation('COURSE_CODE_NAME'),
		dataIndex : 'courseCodeName',
		flex:1
	},{
		header : getCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantCode',
		flex:1
	}]
});
