/**
 *  @author priyanshi sharma
 */

Ext.define('Academia.view.committee.committee.CommitteeApplyToATGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.committeeapplytoatgrid',
	title : getCommonTranslation('ACADEMIC_TERM'),
	store: Ext.create('Academia.store.user.UserAcademyTermsByALStore'),
	selType:'checkboxmodel',
	//cls:'removeGridHorizontalScrollCls',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false,
		deferEmptyText: false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
	},
	border: true,
	tbar: [{
		xtype:'button',
		itemId: 'nextButton',
		text:getCommonTranslation('NEXT'),
		tooltip: getCommonTranslation('NEXT')
	}/*,{
		xtype: 'button',
		text: getCommonTranslation('SUBMITKYS'),
		itemId: 'submitBtn',
		scale: CONSTANTS.BUTTONSIZE
	}*/,{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'academyTermsearchcombo',
		itemId:'academyTermsearchcombo',
		store: Ext.create('Academia.store.user.UserAcademyTermsByALStore'),
		valueField: 'id',
		displayField: 'value',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'academicTermName',
		queryMode: 'remote',
		width: 256,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		margin: '0 0 0 8',
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					//picker.minWidth = picker.up('combobox').getSize().width;
					picker.setWidth( picker.up('combobox').getWidth());
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	}],
	columns: [{
		header : getCommonTranslation('ACADEMIC_TERM'),
		dataIndex : 'value',
		flex : 1	 
	}]
});