/**
 *  @author Priyanshi Sharma
 */

Ext.define('Academia.view.committee.committee.CommitteeApplyToCourseVariantGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.committeeapplytocoursevariantgrid',
	title : getCommonTranslation('COURSE_VARIANT'),
	store: Ext.create('Academia.store.facilitiesresources.managegallery.MapFolderATCourseVariantStore'),
	selType:'checkboxmodel',
	//cls:'removeGridHorizontalScrollCls',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	height:380,
	viewConfig : {
		deferEmptyText: false,
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	border: true,
	emptyText: getCommonTranslation('NORESULTSNMESSAGE'),
	tbar: [{
		xtype: 'button',
		text: getCommonTranslation('SUBMITKYS'),
		itemId: 'submitMapping',
		buttonAlign: 'left',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'coursevariantsearchcombo',
		itemId:'coursevariantsearchcombo',
		valueField: 'sectionId',
		displayField: 'courseVariantCode',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'courseVariantName',
		queryMode: 'remote',
		width: 256,
		store: 'committee.committee.CommitteeATCourseVariantComboStore',
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		margin: '0 0 0 8',
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					//picker.minWidth = picker.up('combobox').getSize().width;
					picker.setWidth( picker.up('combobox').getWidth());
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	}],
	columns: [{
		header : getCommonTranslation('ACADEMIC_TERM'),
		dataIndex : 'academicTermName',
		flex : 1	 
	},{
		header : getCommonTranslation('COURSE_CODE_NAME'),
		dataIndex : 'courseName',
		flex : 1	 
	},{
		header : getCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantCode',
		flex : 1	 
	}]
});