/**
 * @author Amit G
 * 
 */
Ext.define('Academia.view.committee.committee.CommitteeRequestFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.committeerequestfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype : 'radiogroup',
		itemId: 'committeeRadioGrp',
		name:'manageCommittee',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
    		margin:'0 5 0 5'
		},
		
	},{
		xtype:'fieldcontainer',
		width: 600,
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'radiogroup',
			itemId:'requestId',
			defaults: {
				labelAlign : 'top'
			},
			items : [{
				boxLabel : getCommonTranslation('ALL_REQUESTS'),
				name : 'allRequestButton',
				itemId :'allRequestButton',
				inputValue : true,
				checked : true
			},{
				boxLabel : getCommonTranslation('MY_REQUESTS'),
				name : 'allRequestButton',
				itemId :'myRequestButton',
				inputValue : false
			}]
		}]
	},,{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype : 'customcombobox',
			width: 256,
			fieldLabel : getCommonTranslation('MEMBERSHIP_TYPE'),		
			name : 'membershipType',
			itemId : 'membershipType',
			displayField : 'value',
			store:Ext.create('Academia.store.committee.committee.CommitteeMemberShipTypeStore'),
			valueField : 'id',
			typeAhead : true,
			editable : false
		},{
			xtype: 'customcombobox',
			name: 'STUDENT_ID',
			itemId:'studentId',
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: 'committee.committee.CommitteeMemberShipTypeStudentsStore',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
        }]
	},{
		xtype : 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items : [{
    		xtype: 'datefield',
    		name: 'startDate',
    		itemId:'startDate',
    		allowBlank:true,
    		//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		},
    		vtype: 'daterange',
			endDateField: 'endDate',
			editable:false,
    		fieldLabel:getCommonTranslation('START_DATE')
    	},{
    		xtype: 'datefield',
    		name: 'endDate',
    		itemId:'endDate',
    		allowBlank:true,
    		vtype: 'daterange',
			startDateField: 'startDate',
			editable:false,
			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		},
    		fieldLabel:getCommonTranslation('END_DATE')
    	}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation("SEARCH"),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true,
			margin: '0 44 0 0'
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation("RESET"),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

});
