Ext.define('Academia.view.committee.committee.MembershipDetailListGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.membershipdetaillistgrid',
	store :'committee.committee.MembershipDetailStore',
	border: true,
	height:'60%',
	enableColumnHide :false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	style:{
    	'padding-top':'2px',
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'committee.committee.MembershipDetailStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
	this.callParent(arguments);
	},
	columns :[{
    	header: getCommonTranslation("MEMBERSHIP_TYPE"),
        dataIndex: 'membershipType',
        flex:.2,
        sortable: false,
        renderer:function(val,rec,record,rowIndex,colIndex,store,view){
        	if(!isNullOrEmpty(val)){
        		return val.value;
        	}else{
        		return;
        	}
        }
    },{
    	header: getCommonTranslation('MEMBERSHIP_FROM_DATE'),
        dataIndex: 'fromDate',
        flex:.2,
        sortable: false,
        renderer:function(val,rec,record,rowIndex,colIndex,store,view){
        	if(isNullOrEmpty(val)){
        		
        		return;
        	}else{
        		return dateRender(val);
        	}
        }
    },{
    	header: getCommonTranslation('MEMBERSHIP_TILL_DATE'),
        dataIndex: 'toDate',
        flex:.2,
        sortable: false,
        renderer:function(val,rec){
        	if(isNullOrEmpty(val)){
        		return;
        	}else{
        		return dateRender(val);
        	}
        }
    },{
    	header: getCommonTranslation("MEMBERSHIP_STATUS"),
        dataIndex: 'membershipStatus',
        flex:.2,
        sortable: false,
        renderer:function(val,meta,record) {
			var colorValue = '';
			if(!isNullOrEmpty(val)){
				if (val) {
					colorValue = "<span style = 'color:#009e0f;'>Active</span>";
				} else {
					colorValue = "<span style = 'color:#cc0000;'>InActive</span>";
				} 
			return colorValue;
			}
			return;
		}
    }]
});