/**
 * @author bhanu ps
 */
Ext.define('Academia.view.committee.committee.ParticipantGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	title: getCommonTranslation("COMMITTEE_PARTICIPANT_DETAIL"),
	alias : 'widget.participantgrid',
	store: 'committee.committee.CommitteeParticipantGridStore',
	border: true,
	autoScroll: false,
	selType:'checkboxmodel',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		//allowDeselect: false,
		checkOnly : true
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'committee.committee.CommitteeParticipantGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar : [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{	
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls:'windowBtnPos',
		hidden:true,
		defaults: {
			labelAlign:'top',
		},
		items:[{
			xtype: 'button',
			itemId: 'btnSaveItemId',
			tooltip: getExaminationTranslation('SAVE'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			text:getExaminationTranslation('SAVE'),
		}]
	}],
	columns: [{
		header: getCommonTranslation("USER_TYPE"),
		dataIndex: 'participantUserType',
		flex:.1,
		sortable:false,
		renderer:function(val,rec){
			return rec.record.data.userType;
		}

	},{
		header: getCommonTranslation("USER_ID"),
		dataIndex: 'participant',
		flex:.1,
		sortable:false,
		renderer:function(val,rec){
			return rec.record.data.participant.code;
		}

	},{
		header: getCommonTranslation("COMMITTEE_PARTICIPANT_NAME"),
		dataIndex: 'participantsData',
		flex:.1,
		sortable:true
	},{
        header: getCommonTranslation("DESIGNATION_NAME"),
        dataIndex: 'designation',
        flex:.1,
        sortable: true,
        renderer:function(val,rec){
        	if(isNullOrEmpty(val) && isNullOrEmpty(rec.record.data.designation)){
        		return;
        	}else{
	    		if(!isNullOrEmpty(val)) {
        			return val;
        		} else {
        			return rec.record.data.designation;
        		} 
	    	}
        }
    },{
    	header: getCommonTranslation("COMMITTEE_PARTICIPANT_RESPONSABILITY"),
        dataIndex: 'responsibility',
        flex:.1,
        sortable: true,
        renderer:function(val,rec){
        	if(isNullOrEmpty(val) && isNullOrEmpty(rec.record.data.responsibility)){
        		return;
        	}else{
	    		if(!isNullOrEmpty(val)) {
        			return val;
        		} else {
        			return rec.record.data.responsibility;
        		} 
	    	}
        }
    },{
    	header: getCommonTranslation("MEMBERSHIP_DETAILS"),
        dataIndex: 'membershipType',
        flex:.1,
        sortable: true,
        renderer:function(value, meta, record){
			if(!isNullOrEmpty(record)) {
				if(record.data.membershipTypeCount>=1) {					
					return '<a href=#>'+record.data.membershipTypeCount+'<a>';
				} else if(record.data.membershipTypeCount==0) {
					return null;
				} 
			}                        
		}
    },{
    	header: getCommonTranslation("MEMBERSHIP_TYPE"),
        dataIndex: 'membershipDefination',
        flex:.1,
        hidden: true,
        sortable: true,
        renderer:function(val,rec,record,rowIndex,colIndex,store,view){
        	if(!isNullOrEmpty(val)){
        		
        		return val.membershiptype;
        	}else{
        		return;
        	}
        }
    },{
    	header: getExaminationTranslation('FROM_DATE'),
        dataIndex: 'fromDate',
        flex:.1,
        hidden: true,
        sortable: true,
        renderer:function(val,rec,record,rowIndex,colIndex,store,view){
        	if(isNullOrEmpty(val)){
        		
        		return;
        	}else{
        		return dateRender(val);
        	}
        }
    },{
    	header: getExaminationTranslation('TILL_DATE'),
        dataIndex: 'toDate',
        flex:.1,
        hidden: true,
        sortable: true,
        renderer:function(val,rec){
        	if(isNullOrEmpty(val)){
        		return;
        	}else{
        		return dateRender(val);
        	}
        }
    },{
    	header: getCommonTranslation("MEMBERSHIP_STATUS"),
        dataIndex: 'membershipStatus',
        flex:.1,
        hidden: true,
        sortable: true,
        renderer:function(val,meta,record) {
			var colorValue = '';
			if(!isNullOrEmpty(val)){
				if (val) {
					colorValue = "<span style = 'color:#009e0f;'>Active</span>";
				} else {
					colorValue = "<span style = 'color:#cc0000;'>InActive</span>";
				} 
			return colorValue;
			}
			return;
		}
    }]
});