/**
 * @author Harshit patidar
 */
Ext.define('Academia.view.committee.committee.StudentApplyForCommitteeGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentapplyforcommitteegrid',
	store: 'committee.committee.StudentApplyForCommitteeGridStore',
	title: getCommonTranslation("ALL_COMMITTEE_REQUESTS"),
	border: true,
	autoScroll: false,
	frame:false,
	style:{
		     "margin-bottom":"30px !important"
			    },
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'committee.committee.StudentApplyForCommitteeGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar: [ {
        xtype: 'button',
        itemId: 'raiseRequest',
        text: getCommonTranslation('RAISE_REQUEST'),
        tooltip: getCommonTranslation('RAISE_REQUEST'),
    },{
		xtype: 'button',
		itemId: 'cancelRequest',
        text: getCommonTranslation('CANCEL_REQUEST'),
		tooltip: getCommonTranslation("CANCEL_REQUEST"),
	} ],
	columns: [{
		header:  getCommonTranslation("REQUEST_ID"),
		dataIndex: 'id',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.id)){
				return '<a href=#>'+record.data.id+'</a>';
			}
		}
	},{
		header:  getCommonTranslation("COMMITTEE_NAME"),
		dataIndex: 'committeeId',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.committeeId)){
				return record.data.committeeId.value;
			}
		}
	},{
		header:  getCommonTranslation("MEMBERSHIP_TYPE"),
		dataIndex: 'membershipTypeId',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.membershipTypeId)){
				return record.data.membershipTypeId.value;
			}
		}
	},{
		header:  getCommonTranslation("REQUEST_DATE"),
		dataIndex: 'requestDate',
		flex:.1,
		sortable:true,
		renderer : function(value){
       		return  dateRender(value);   	
        }
	},{
		header:  getCommonTranslation("REQUEST_ASSIGNED_TO"),
		dataIndex: 'requestAssignTo',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.requestAssignTo)){
				return record.data.requestAssignTo.value;
			}else
				{
				return "Auto";
				}
		}
	},{
		header:  getCommonTranslation("REQUEST_STATUS"),
		dataIndex: 'approvalStatus',
		flex:.1,
		sortable:true,
		renderer : function(value, metadata, record) {
			var val = '';
			if(value == 'PENDING') {
				val = 'Pending';
			}else if(value == 'APPROVED') {
				val = 'Approved';
			}else if(value == 'CANCELLED'){
				val = 'Cancelled';
			}else{
				val = 'Rejected';
			}
			return val;
		}
	}]
});
