/**
 * @author Rohit Thadani
 */
Ext.define('Academia.view.committee.committee.StudentCommitteeALWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.studentcommitteealwindow',
	title:getCommonTranslation("COMMITTEE_ACADEMY_LOCATION"),
	modal: true,
	autoScroll:true,
	maxHeight:500,
	width: '58%',
	height:'40%',
	items: [{
		xtype: 'form',
		method: 'POST',
		itemId:'academyLocationForm',
		hidden:true,
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			style:{
				marginLeft:'15px'
			},
			defaults :{
				width: 536,
			},
			items: [{
				xtype:'displayfield',
				name:'committeeName',
				itemId:'committeeNameAL',
				fieldLabel:getCommonTranslation("COMMITTEE_CODE")
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 536
			},
			items: [{
				xtype: 'committeealgrid',
				name:'academyLocationGrid',
				itemId:'academyLocationGridItemId',
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			items: [{
	            xtype: 'button',
	            text: getServiceRequestTranslation('CANCEL'),
	            ui: 'CustomBtnCancel',
	            itemId: 'cancelButtonId',
	            scale: CONSTANTS.BUTTONSIZE,
	            handler :function(button) {
	            	button.up('window').close();
	            }
	        }]
		}]
	},{
		xtype: 'form',
		method: 'POST',
		itemId:'descriptionForm',
		hidden:true,
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			style:{
//				marginLeft:'15px'
			},
			defaults :{
				width: 536,
			},
			items: [{
				xtype:'displayfield',
				name:'committeeName',
				itemId:'committeeNameDesc',
				fieldLabel:getCommonTranslation("COMMITTEE_CODE")
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 536
			},
			items: [{
				xtype: 'textarea',
				name:'description',
				itemId:'description',
				//maxLength : 250,
				fieldLabel: getExaminationTranslation('Description')
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			items: [{
	            xtype: 'button',
	            text: getServiceRequestTranslation('CANCEL'),
	            ui: 'CustomBtnCancel',
	            itemId: 'cancelButtonId',
	            scale: CONSTANTS.BUTTONSIZE,
	            handler :function(button) {
	            	button.up('window').close();
	            }
	        }]
		}]
	},{
		xtype: 'form',
		method: 'POST',
		itemId:'mapCommitteeWindowId',
		hidden:true,
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			//width: 300,
			items: [{
				xtype: 'customcombobox',
				name: 'committee',
				itemId:'committeeItemId',
				store:'committee.committee.StudentCommitteeStore',
				displayField:'valueCode',
				valueField:'id',
				forceSelection:true,
				allowBlank:false,
				typeAhead:true,
				fieldLabel:getCommonTranslation("COMMITTEE_CODE_NAME"),
				listeners: {
					change: function(object) {
						object.up().up().isValid();
					}
				},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							//picker.minWidth = picker.up('combobox').getSize().width;
						}
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'hbox'
			},
			width:'auto',
			items : [{
				xtype : 'button',
				text : getCommonTranslation("SAVE") ,
				itemId : 'submitBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
                xtype: 'button',
                text: getServiceRequestTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE,
                handler :function(button) {
                	button.up('window').close();
                }
            }]
		}]
	},{
		xtype: 'form',
		method: 'POST',
		itemId:'mapCommitteeParticipantWindowId',
		hidden:true,
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'customcombobox',
				name: 'userType',
				itemId: 'userType',
				fieldLabel: getFileManagementTranslation('USER_TYPE'),
				editable: false,
				disableKeyFilter: false,
				valueField: 'id',
				allowBlank:false,
				displayField: 'userGroupName',
				store: 'attendance.UserGroup'
			},{
				xtype: 'customcombobox',
				name:'assignedUser',
				itemId:'assignedUser',
				fieldLabel : getFileManagementTranslation('USER'),
				msgTarget: 'qtip',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'codeOrName',
				minChars:3,
				disabled:true,
				allowBlank:false,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listeners:{
					render : function(combo){
						var store=Ext.create('Academia.store.hostel.roomallocation.UserSmartSearchByUserType');
						combo.bindStore(store)
					}
				},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'textfield',
				name:'designationName',
				itemId:'designationNameItemId',
				fieldLabel:getCommonTranslation('DESIGNATION_NAME'),
				maxLength: 50
			}]
		},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				    xtype: 'textfield',
		            name:'responsability',
		            itemId:'responsabilityItemId',
		            fieldLabel:getCommonTranslation('COMMITTEE_PARTICIPANT_RESPONSABILITY'),
		            maxLength: 250
			},{
				xtype: 'datefield',
				endDateField:'toDateItemId',
				vtype: 'daterange',
				fieldLabel:getExaminationTranslation('FROM_DATE'),
				name: 'fromDate',
				itemId:'fromDateItemId',
				vtype: 'daterange',
				//--submitFormat:CONSTANTS.DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				xtype: 'datefield',
				name: 'toDate',
				itemId:'toDateItemId',
				//--submitFormat:CONSTANTS.DATE_FORMAT,
				fieldLabel:getExaminationTranslation('TILL_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'hbox'
			},
			width:'auto',
			items : [{
				xtype : 'button',
				text : getCommonTranslation('SAVE'),
				itemId : 'submitCommitteeParticipantBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
                xtype: 'button',
                text: getServiceRequestTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE,
                handler :function(button) {
                	button.up('window').close();
                }
            }]
		}]
	}],
	
    persistCommitteeMaping: function(button, grid) {
    	baseController = Academia.app.getController('Academia.controller.base.BaseController');
		var formData = button.up('form').getValues();
    	var json=[];
    	var record = grid.getSelectionModel().getSelection();
    	for(var i in record){
    		var committee={
    				"id":formData.committee
    		};
    		var participant={
    				"id":record[i].data.ID
    		};
    		json.push({
    			"committee":committee,
    			"participant":participant
    		})
    	}
    	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	var	submitUrl=SERVERURL.COMMITTEE_PARTICIPANT_CREATE;
    	Ext.Ajax.request({
    		type : 'rest',
    		url : submitUrl,
    		jsonData : json,
    		method : 'POST',
    		success : function(form, action) {
    			Ext.getBody().unmask();
    			showSuccessMessage(getCommonTranslation("COMMITTEE"),getCommonTranslation('SUCCESS'));
    			button.up().up().up().close();
    		}
    	});
    }
});