/**
 * @author Vishal Joshi
 */
Ext.define('Academia.view.committee.committee.StudentCommitteeGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentcommitteegrid',
	store: 'committee.committee.StudentCommitteeGridStore',
	title: getCommonTranslation("LIST_OF_COMMITTEE"),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'committee.committee.StudentCommitteeGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar: [/*{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	}, */{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	}/*, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	}*//*,{
		xtype: 'button',
		itemId: 'addMeetingBtn',
		text:getCommonTranslation('ADD_MEETING'),
		tooltip :getCommonTranslation('ADD_MEETING')
	},{
		xtype: 'button',
		itemId: 'sendMessageBtn',
		text:getCommonTranslation('SEND_MESSAGE'),
		tooltip :getCommonTranslation('SEND_MESSAGE')
	}*/],
	columns: [/*{
		header:  getExaminationTranslation('ID'),
		dataIndex: 'id',
		flex:.1,
		hidden:true,
		sortable:true
	},*/{
		header:  getCommonTranslation("COMMITTEE_CODE"),
		dataIndex: 'committeeCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("COMMITTEE_NAME"),
		dataIndex: 'committeeName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("COMMITTEE_CO_ORDINATOR"),
		dataIndex: 'committeeCoordinatorName',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.committeeCoordinatorName)){
				return record.data.committeeCoordinatorName;
			} else {
				return '-';
			}
		}
	},{
		header:  getCommonTranslation("NO_OF_PARTICIPANT"),
		dataIndex: 'noOfParticipants',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.noOfParticipants)){
				return '<a href=#>'+record.data.noOfParticipants+'</a>';
			}
		}
	},{
		header:  getCommonTranslation("ACADEMY_LOCATION"),
		dataIndex: 'committeeAcademyLocations',
		flex:.1,
		sortable:true,
		hidden:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.committeeAcademyLocations)){
			    return '<a href=#>'+record.data.committeeAcademyLocations.length+'</a>';
			} else {
				return '-';
			}
		}
	},{
		header:  getCommonTranslation("DESCRIPTION"),
		dataIndex: 'description',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.description)){
			    return '<a href=#>View</a>';
			} else {
				return '-';
			}
		}
	}]
});
