/**
 * @author bhanu ps
 */
Ext.define('Academia.view.committee.committee.StudentParticipantGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	title: getCommonTranslation("COMMITTEE_PARTICIPANT_DETAIL"),
	alias : 'widget.studentparticipantgrid',
	store: 'committee.committee.CommitteeParticipantGridStore',
	border: true,
	autoScroll: false,
	//selType:'checkboxmodel',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	/*selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		//allowDeselect: false,
		checkOnly : true
	},*/
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'committee.committee.CommitteeParticipantGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	//tbar : [{}],
	columns: [{
		header: getCommonTranslation("USER_TYPE"),
		dataIndex: 'participantUserType',
		flex:.1,
		sortable:true,
		renderer:function(val,rec){
			return rec.record.data.userType;
		}

	},{
		header: getCommonTranslation("USER_ID"),
		dataIndex: 'participant',
		flex:.1,
		sortable:false,
		renderer:function(val,rec){
			return rec.record.data.participant.code;
		}

	},{
		header: getCommonTranslation("COMMITTEE_PARTICIPANT_NAME"),
		dataIndex: 'participant',
		flex:.1,
		sortable:true,
		renderer:function(val,rec){
			return rec.record.data.participant.value;
		}
	},{
        header: getCommonTranslation("DESIGNATION_NAME"),
        dataIndex: 'designation',
        flex:.1,
        sortable: true,
        flex:.1,
        sortable: true,
        renderer:function(val,rec){
        	if(isNullOrEmpty(val) && isNullOrEmpty(rec.record.data.designation)){
        		return '-';
        	}else{
	    		if(!isNullOrEmpty(val)) {
        			return val;
        		} else {
        			return rec.record.data.designation;
        		} 
	    	}
        }
    },{
    	header: getCommonTranslation("COMMITTEE_PARTICIPANT_RESPONSABILITY"),
        dataIndex: 'responsibility',
        flex:.1,
        sortable: true,
        renderer:function(val,rec){
        	if(isNullOrEmpty(val) && isNullOrEmpty(rec.record.data.responsibility)){
        		return '-';
        	}else{
	    		if(!isNullOrEmpty(val)) {
        			return val;
        		} else {
        			return rec.record.data.responsibility;
        		} 
	    	}
        }
    },{
    	header: getExaminationTranslation('FROM_DATE'),
        dataIndex: 'fromDate',
        flex:.1,
        sortable: true,
        renderer:function(val,rec,record,rowIndex,colIndex,store,view){
        	if(isNullOrEmpty(val)){
        		return '-';
        	}else{
        		return dateRender(val);
        	}
        }
    },{
    	header: getExaminationTranslation('TILL_DATE'),
        dataIndex: 'toDate',
        flex:.1,
        sortable: true,
        renderer:function(val,rec){
        	if(isNullOrEmpty(val)){
        		return '-';
        	}else{
        		return dateRender(val);
        	}
        }
    }],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners: {
			beforeedit: function(obj, editor, context){
			}
		}
	}]
});
var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {	
	clicksToEdit: 1,
	listeners : {
		beforeedit:function(editor, context, e){
		}
	}
});