/**
 *	This is used for Application CheckList grid
 */
Ext.define('Academia.view.common.ApplicationCheckListGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.applicationchecklistgrid',
    collapsible: false,
    border: true,
    viewConfig: {
        stripeRows: true
    },
    columns: [{
        header: getUserModuleTranslation('CHECKLIST'),
        dataIndex: 'checklistValue',
        sortable: true,
        flex : 1
    }],
    tbar : [],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.admission.applications.applicantservice.ApplicantChekLists');
    }
});