/**
 * @author Sandeep Pal
 */
Ext.define('Academia.view.common.AttestationStatementOfStudentJourneyWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.attestationstatementofstudentjourneywindow',
    modal: true,
    autoScroll: true,
    frame: true,
    width:500,
    title: getMessagingModuleTranslation('ANNOUNCEMENT'),
    plugins: "formlabelrequired",
    items: [{
        xtype: 'form',
        itemId: 'msgDetailsForm',
        items: [{
                xtype: 'fieldcontainer',
                width: '100%',
                layout: {
                    type: 'vbox'
                },
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                items: [{
                    xtype: 'customcombobox',
                    fieldLabel:  getCommonTranslation('TEMPLATE_NAME'),                
                    name: 'templateName',
                    itemId : 'templateNameId',   
                    valueField: 'id',
					displayField: 'valueCode',
                    store: Ext.create('Ext.data.Store', {
					    fields: ['id', 'valueCode'],
					    data: [{
							id: 'Attestation Statement Of Student Journey',
							valueCode: 'Attestation Statement Of Student Journey'
						}]
					}),
                    allowBlank: false,
                    editable: false
                }]
            },{
                xtype: 'fieldcontainer',
                width: '100%',
                layout: {
                    type: 'vbox'
                },
                defaults: {
                    labelAlign: 'top',
                    width: 256
                }
            },{
                xtype: 'fieldcontainer',
                items: [{
        			xtype: 'checkboxfield',
        			width: 'auto',
        			labelAlign: 'right',
        			itemId:'attestationPrintAsWordFile',
        			hidden:true,
        			boxLabel: getCommonTranslation('PRINT_AS_WORD_FILE'),
        			name: 'attestationPrintAsWordFile',
        			inputValue : true
        		}]
            },{
            xtype: 'fieldcontainer',
            width: '100%',
            style :{
            	marginLeft :'1px',
            	marginTop :'10px'
            },
            items: [{
                xtype: 'button',
                text: getServiceRequestTranslation('SUBMIT'),
                itemId: 'submitPrintAttestation',
                ui: 'CustomBtnSubmit',
                formBind : true,
                scale: CONSTANTS.BUTTONSIZE              
            }, {
                xtype: 'button',
                text: getCommonTranslation('SEND_TO_STUDENT_PROFILE'),
                itemId: 'sendMultipleAttestationToStudentProfile',
                ui: 'CustomBtnSubmit',
                formBind : true,
                scale: CONSTANTS.BUTTONSIZE              
            }, {
                xtype: 'button',
                text: getServiceRequestTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'attestationCancelButtonId',
                scale: CONSTANTS.BUTTONSIZE,
                handler :function(button) {
                	button.up('window').close();
                }
            }]
        }]
    }]
});