/**
 * @author bhanu pratap singh
 */
Ext.define('Academia.view.common.CertificateSelectionWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.certificateselectionwindow',
    modal: true,
    autoScroll: true,
    width:450,
    maxHeight : 350,
    frame: true,
    title: getMessagingModuleTranslation('ANNOUNCEMENT'),
    plugins: "formlabelrequired",
    items: [{
        xtype: 'form',
        itemId: 'msgDetailsForm',
        items: [{
                xtype: 'fieldcontainer',
                width: '100%',
                layout: {
                    type: 'vbox'
                },
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                items: [{
                    xtype: 'customcombobox',
                    fieldLabel:  getCommonTranslation('CERTIFICATE_NAME'),                
                    name: 'certificate',
                    itemId : 'certificate',   
                    displayField : 'value',
                    valueField:'id',
					store: 'reports.servicerequest.CertificateSubCategoryStore',
					allowBlank: false,
					editable: false,
					/* listeners: {
						 render: function(combo){
							 var store = Ext.create('Academia.store.reports.servicerequest.CertificateSubCategoryStore');
							 combo.bindStore(store);
						 }
					 }*/
				}, {
						xtype: 'customcombobox',
						fieldLabel: getCommonTranslation('PERIOD_NAME'),
						name: 'periodName',
						itemId: 'periodName',
						displayField: 'value',
						valueField: 'id',
						qry:'name',
						store: 'reports.servicerequest.PeriodCertificateMappingStore',
						allowBlank: false,
						editable: false,
						hidden:true
						/* listeners: {
							 render: function(combo){
								 var store = Ext.create('Academia.store.reports.servicerequest.CertificateSubCategoryStore');
								 combo.bindStore(store);
							 }
						 }*/
					}]
            },{
                xtype: 'fieldcontainer',
                width: '100%',
                layout: {
                    type: 'vbox'
                },
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                items: [{
                    xtype: 'customcombobox',
                    fieldLabel:  getCommonTranslation('DATEFORMAT'),                
                    name: 'certificateDateFormat',
                    itemId : 'certificateDateFormatId',   
                    displayField : 'value',
                    valueField:'id',
                    store: Ext.create('Ext.data.Store', {
                        fields: ['id', 'value'],
                        data: [
                            { id: 'DEFAULT', value: 'Default' },
                            { id: 'MONTHYEAR_en', value: 'Month and year only in English' },
                            { id: 'MONTHYEAR_fr', value: 'Month and year only in French' },
                            { id: 'MONTHYEAR_es', value: 'Month and year only in Spanish' },
                            { id: 'FULL_en', value: 'Full date in English' },
                            { id: 'FULL_fr', value: 'Full date in French' },
                            { id: 'FULL_es', value: 'Full date in Spanish' }
                        ]
                    }),
                    allowBlank: true,
                    editable: false,
                    hidden: true,
                    value: 'DEFAULT'
                }]
            },{
                xtype: 'fieldcontainer',
                width: '100%',
                layout: {
                    type: 'vbox'
                },
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                items: [{ 
                	xtype: 'textareafield',
                    name: 'certificateComment',
                    itemId : 'certificateComment', 
                    fieldLabel: getServiceRequestTranslation('CERTIFICATE_COMMENT'),
                    maxLength: 1000,
                    allowBlank: true,
                    hidden:true
                    }]
            },{
                xtype: 'fieldcontainer',
                items: [{
        			xtype: 'checkboxfield',
        			width: 'auto',
        			labelAlign: 'right',
        			itemId:'printAsWordFile',
        			hidden:true,
        			boxLabel: getCommonTranslation('PRINT_AS_WORD_FILE'),
        			name: 'printAsWordFile',
        			inputValue : true
        		}]
            },{
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                text: getServiceRequestTranslation('SUBMIT'),
                itemId: 'submitPrintCertificate',
                ui: 'CustomBtnSubmit',
                formBind : true,
                scale: CONSTANTS.BUTTONSIZE              
            }, {
                xtype: 'button',
                text: getCommonTranslation('SEND_TO_STUDENT_PROFILE'),
                itemId: 'sendMultipleCertificateToStudentProfile',
                ui: 'CustomBtnSubmit',
                formBind : true,
                scale: CONSTANTS.BUTTONSIZE              
            }, {
                xtype: 'button',
                text: getServiceRequestTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'followUpDetailsCancelButtonId',
                scale: CONSTANTS.BUTTONSIZE,
                handler :function(button) {
                	button.up('window').close();
                }
            }]
        }]
    }]
});