/**
 * @author <a href="mailto:ankush.solanki@serosoft.in">Ankush Solanki</a>
 *
 */
Ext.define('Academia.view.completion.completionlist.CompletionDetailWindowForm', {
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.completiondetailwindowform',
	autoScroll:false,
	plugins : "formlabelrequired",
	items:[{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			items: [{
				xtype: 'checkboxfield',
				itemId: 'markCheckListComplete',
				labelAlign: 'right',
				boxLabel: getProgramandcourseTranslation('MARK_CHECKLIST_COMPLETE'),
				name: 'markCheckListComplete',
				inputValue: true,
				uncheckedValue: false
			},{
				xtype: 'checkboxfield',
				itemId: 'markCertificateComplete',
				labelAlign: 'right',
				boxLabel: getProgramandcourseTranslation('MARK_CERTIFICATE_COMPLETE'),
				name: 'markCertificateComplete',
				inputValue: true,
				uncheckedValue: false
			}]
		},{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('EFFECTIVE_PASSOUT_DATE'),
				name : 'effectiveTrasferDate',
				itemId:'effectiveTrasferDate',
				allowBlank: false,
			//	hidden:true,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);
					}
				}
			},{
				xtype : 'textfield',
				fieldLabel : getProgramandcourseTranslation('DECISION_NUMBER'),
				name : 'decisionNumber',
				itemId:'decisionNumber',
				allowBlank: true,
			}]
		},{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'datefield',
				fieldLabel: getCompletionModuleTranslation('EFFECTIVE_PASSOUT_COMMUNICATION_DATE'),
				disabled: false,
				name: 'effectivePassoutCommunicationDate',
				itemId: 'effectivePassoutCommunicationDate',
				labelAlign: 'top',
				width: 250,
				editable: true,
				allowBlank: true,
				hidden:true,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout : 'hbox',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'completeCompletionSaveItemId',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				formBind : true,     // Uncommented for V2D-444958
				//disabled:true,
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('CANCEL'),
				itemId: 'completeCompletionCancelItemId',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});