/**
 *  @author pritam.patil
 *  Termination's General TAb Form 
 */
Ext.define('Academia.view.completion.completionlistforms.TerminationGeneralForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.terminationgeneralform',
    items: [{
        xtype: 'fieldset',
        collapsed: false,
        plugins: "formlabelrequired",
        items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            style :{
	        	marginTop : '-5px',
	        	marginLeft : '9px'
	        },
            items: [{xtype : 'hidden',
            	name : 'id'},
            {	xtype : 'hidden',
            	name : 'version'},
            {
                xtype: 'datefield',
                fieldLabel: getCompletionModuleTranslation('TERMINATION_EFFECTIVE_DATE_FROM'),
                name: 'effectiveDate',
                itemId: 'startDate',
                allowBlank: false,     
                editable : false,
//                minValue : new Date() ,
              //--submitFormat: CONSTANTS.DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					},
					beforerender: function(field){
						if(field.up('tempterminationtabpanel')){
							field.setFieldLabel(getCompletionModuleTranslation('DEBARMENT_EFFECTIVE_DATE_FROM'))
						}
					}
				}
            },{
                xtype: 'datefield',
                fieldLabel: getCompletionModuleTranslation('TERMINATION_TILL_DATE'),
                name: 'tillDate',
                itemId: 'endDate',
                readOnly : true,
              //--submitFormat: CONSTANTS.DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					},
					beforerender: function(field){
						if(field.up('tempterminationtabpanel')){
							field.setFieldLabel(getCompletionModuleTranslation('DEBARMENT_TILL_DATE'))
						}
					}
				}
            }]
        }, {
        	xtype: 'fieldset',
        	collapsed: false,
        	itemId: 'terminationReasonsGeneralFieldset',
        	layout: 'vbox',
        	style:{
        		'margin-top': '0px !important;',
        		'padding-top': '0px !important;',
        		'padding-bottom': '0px !important;'
        	},
        	items: []
        },/*{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            style :{
	        	marginTop : '-5px',
	        	marginLeft : '9px'
	        },
            items: [{
            	 xtype: 'customcombobox',
                 fieldLabel: getCompletionModuleTranslation('TERMINATION_REASON'),
                 name: 'reason',
                 valueField: 'id',
                 readOnly : true,
                 itemId: 'terminationGeneralReason',
                 displayField: 'value'
            }]
        },*/ {
            xtype: 'fieldcontainer',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            style :{
	        	marginTop : '-5px',
	        	marginLeft : '9px'
	        },
            layout: 'vbox',
            items: [{
                xtype: 'textareafield',
                name: 'remark',
                width: 400,
                itemId : 'terminationRemark',
                readOnly : true,
                fieldLabel: getCompletionModuleTranslation('TERMINATION_REMARKS'),
				listeners: {
					beforerender: function(field){
						if(field.up('tempterminationtabpanel')){
							field.setFieldLabel(getCompletionModuleTranslation('DEBARMENT_REMARKS'))
						}
					}
				}
            }, {
                xtype: 'textareafield',
                name: 'studentRemark',
                width: 400,
                itemId : 'studentRemarkId',
                readOnly : true,
                fieldLabel: getCompletionModuleTranslation('STUDENT_REMARKS')
            },{
                xtype: 'textfield',
                width: 256,
                labelAlign: 'top',
                name: 'approvedBy',
                readOnly : true,
                fieldLabel: getCompletionModuleTranslation('APPROVED_BY'),  
                itemId: 'approvedById'
            }]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            itemId: 'generalSubmitBtn',
            text: getCompletionModuleTranslation('SUBMIT'), //Submit
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            disabled : true
        }, {
            xtype: 'button',
            text: getCompletionModuleTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            name : 'terminationGeneralCancelBtn',
            itemId: 'generalCancel',
            scale: CONSTANTS.BUTTONSIZE,
            cls: 'btn-with-no-icon'
        }]
    }]
    }]
});