/**
 * @author pritam.patil
 * Completion Pending Bill Grid
 */
Ext.define('Academia.view.completion.completionlistforms.common.CompletionPendingBillGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.completionpendingbillgrid',
    border: true,
    title : getCompletionModuleTranslation('PENDING_REFUNDABLES'),
    viewConfig: {
        stripeRows: true
    },
    plugins : [ {
		ptype : 'rowexpander',
		rowBodyTpl : [ '<tpl for="."><tpl if="!Ext.isEmpty(studentPendingPaymentHeadWiseDetails)">',
		               	'<table style="border:1px solid black; width:90%;">',

		               	'<col style="width:20%">',
		                '<col style="width:20%">',
		                '<col style="width:20%">',
		                '<col style="width:10%">',
		                '<col style="width:10%">',
		                '<col style="width:10%">',
		                '<col style="width:10%">',
		                '<thead>',
		                '<tr>',
		                        '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'+getCompletionModuleTranslation('FEE_PLAN_NAME')+'</th>',
		                        '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'+getCompletionModuleTranslation('FEE_HEAD_NAME')+'</th>',
		                        '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'+getCompletionModuleTranslation('STAGE_NAME')+'</th>',
		                        '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'+getCompletionModuleTranslation('FEE_AMOUNT')+'</th>',
		                        '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'+getCompletionModuleTranslation('DISCOUNT_AMOUNT')+'</th>',
		                        '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'+getCompletionModuleTranslation('ADJUSTED_AMOUNT')+'</th>',
		                        '<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">'+getCompletionModuleTranslation('BALANCE')+'</th>',
		                '</tr>',
		                '</thead>',
		               		'<tpl for="studentPendingPaymentHeadWiseDetails">',
		               			'<tr>',
		               				'<td style="width:100px;text-align:center">{feePlanName}</td>',
		               				'<td style="width:100px;text-align:center">{feeHeadName}</td>',
		               				'<td style="width:100px;text-align:center">{stageName}</td>',
		               				'<td style="width:100px;text-align:center">{feeAmount}</td>',
		               				'<td style="width:100px;text-align:center">{discountAmount}</td>',
		               				'<td style="width:100px;text-align:center">{adjustedAmount}</td>',
		               				'<td style="width:100px;text-align:center">{balanceAmount}</td>',
		               			'</tr>',
		               		'</tpl>',
		               	'</table></tpl>',
		               '</tpl>' ]
	} ],
    columns: [{
        header: getServiceRequestTranslation('BILL_NO'),
        dataIndex: 'billNo',
        sortable: true,
        flex: .2
    }, {
        header: getServiceRequestTranslation('BILLING_DATE'),
        dataIndex: 'billingDate',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getServiceRequestTranslation('DUE_DATE'),
        dataIndex: 'dueDate',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    },{
        header: getServiceRequestTranslation('BILL_AMOUNT'),
        dataIndex: 'totalAmount',
        sortable: true,
        flex: .2
    }],
    initComponent: function() {
       var this$ = this;
       var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
   buildStore: function() {
     return Ext.create('Academia.store.completion.completionform.PendingBillGrids');
    }

});
