/**
 * @author sachin.bangar
 * This is the basic set-up panel for Completion Settings module
 */
Ext.define('Academia.view.completion.setup.CompletionSettingPanel', {
    extend: 'Ext.tab.Panel',
    xtype: 'plain-tabs',
    alias: 'widget.completionsettingpanel',
    autoScroll: false,
	cls:'SearchTabPanelWithRightTabs panelNoSpace horizontalScrollingFixed' ,
	
	/* requires :['Academia.view.sponsorship.SponsorshipListingScreen' ], */
	tabbar: {
		cls:'SearchTabPanelWithRightTabs',
		componentCls: 'searchTabComponent'
	},
	tabPosition: 'top',
	plain: true,

    items: [{
    	xtype: 'managetransactiontypepanel',
    	itemId : 'manageTransactionTypePanel',
        title: getCompletionModuleTranslation('MANAGE_TRANSACTION_TYPE'),
        closable: false
    }, {
    	xtype: 'managechecklistitempanel',
    	itemId : 'manageChecklistItemPanel',
        title: getCompletionModuleTranslation('MANAGE_CHECKLIST_ITEM'),
        closable: false
    }, {
    	xtype: 'mapchecklistcertificatepanel',
    	itemId : 'mapChecklistToTransactionPanel',
        title: getCompletionModuleTranslation('MAP_CHECKLIST_WITH_TRANSACTION_TYPE'),
        closable: false,
        items : [{
        	xtype : 'mapchecklistwithtransactiontypeform',
        	itemId : 'mapChecklistWithTransactionTypeForm'
        }]
    },{
    	xtype: 'mapchecklistcertificatepanel',
    	itemId : 'mapCertificateToTransactionPanel',
        title: getCompletionModuleTranslation('MAP_CERTIFICATE_WITH_TRANSACTION_TYPE'),
        closable: false,
        items : [{
        	xtype : 'mapcertificatewithtransactiontypeform',
        	itemId : 'mapCertificateWithTransactionTypeForm'
        }]
    },{
    	xtype: 'managecompletionchecklistpanel',
    	itemId : 'manageCompletionChecklistPanel',
        title: getCompletionModuleTranslation('MANAGE_COMPLETION_CHECKLIST'),
        closable: false
    }]
});