/**
 * @author sachin.bangar
 * This grid is used for Manage CheckList Item
 */

Ext.define('Academia.view.completion.setup.ManageCheckListItemGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.managechecklistitemgrid',
    title: getCompletionModuleTranslation('MANAGE_CHECKLIST_ITEM'),
    border: true,
    autoScroll: false,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
        header: getCompletionModuleTranslation('CHECKLIST_ITEM'),
        dataIndex: 'value',
        sortable: true,
        flex : 1
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.completion.setup.CheckListItemStore');
    }
});