/**
 * @author sachin.bangar
 * This form is used for Manage Transaction Type
 */
Ext.define('Academia.view.completion.setup.ManageTransactionTypeForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.managetransactiontypeform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    defaults: {
        labelAlign: 'top',
        width: 256
    },
    items: [{
        xtype: 'hidden',
        itemId: 'transaction_hidden_field',
        name: 'id'
    }/*, {
        xtype: 'hidden',
        name: 'version'
    }*/, {
        xtype: 'textfield',
        fieldLabel: getCompletionModuleTranslation('TRANSACTION_TYPE_CODE'),
        
        name: 'code'
    }, {
        xtype: 'textfield',
        fieldLabel: getCompletionModuleTranslation('TRANSACTION_TYPE'),
        
        name: 'value'
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});