/**
 * @author sachin.bangar
 * This form is used to map CheckList Item/Certificate with Transaction Type
 */
Ext.define('Academia.view.completion.setup.MapCertificateWithTransactionTypeForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.mapcertificatewithtransactiontypeform',
    border : false,
    frame : false,
  //  		
    plugins: "formlabelrequired",
    cls:'x-form-fixed-footer-parent',
    initComponent: function() {
        var this$ = this;     

        var store = this$.buildStore();        
        
        this$.items = [{
            xtype: 'hidden',
            itemId: 'map_hidden_field',
            name: 'id'
        }, {
            xtype: 'hidden',
            name: 'version'
        }, {
            xtype: 'nestedJsonCombo',
            itemId : 'certificateTransactionTypeCombo',
            labelWidth : 150,
            width : 376,
            style :{
            	marginLeft : '10px',
            	marginTop : '25px'
            },
            fieldLabel: getCompletionModuleTranslation('TRANSACTION_TYPE'),
            store : 'completion.setup.TransactionTypesExceptTempTermination',
            valueField: 'id',
            displayField: 'translatedCode',  
            name: 'transactionType',
            allowBlank: false,
            editable: false
        }, {
            xtype: 'itemselector',
            cls: 'itemSelectorCls',
            itemId: 'mapCertificateItemSelector',
            labelAlign: 'top',
            name: 'certificates',
            width : 700,
            maxHeight:400,
            autoScroll:true,
            style : {
            	marginTop: '25px'
            },
            allowBlank: false,
            store : store,
            displayField: 'value',
            valueField: 'id',
            editable: false,
            queryMode : 'local',
            fromTitle: getCompletionModuleTranslation('AVAILABLE_CERTIFICATE_ITEM'),
            toTitle: getCompletionModuleTranslation('APPLICABLE_CERTIFICATE_ITEM'),
            delimiter: null,
            buttons: ['top', 'add', 'remove', 'bottom']
    	},{
            xtype: 'fieldcontainer',
            width: '100%',
            style : {
            	marginLeft : '8px'
            },
            items: [{
            	xtype:'fieldcontainer',
            	cls:'form-fixed-footer',
            	items:[{
                    xtype: 'button',
                    text: getCommonTranslation('SAVE'),
                    itemId: 'submitButtonId',
                    buttonAlign: 'right',
                    ui: 'CustomBtnSubmit',
                    scale: CONSTANTS.BUTTONSIZE,
                    formBind: true,
                    handler :function(){
                    	this.setDisabled(true);
                    }
                }]
            }]
        }];
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.completion.setup.CompletionCertificates');
    }
});