/**
 * @author sachin.bangar
 * This form is used to map CheckList Item/Certificate with Transaction Type
 */
Ext.define('Academia.view.completion.setup.MapItemWithTransactionForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.mapitemwithtransactionform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    initComponent: function() {
        var this$ = this;     

        var checkListStore = this$.buildCheckListStore();   
        var certificateStore = this$.buildCertificateStore();    
        
        this$.items= [{
            xtype: 'hidden',
            itemId: 'map_hidden_field',
            name: 'id'
        }, {
            xtype: 'hidden',
            itemId: 'isEditId',
            name : 'isEdit',
            value : 'false'
        },{
            xtype: 'hidden',
            name: 'progBatchSeatConfId'
        }, {
        	xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		labelAlign: 'top',
        		width: 256
        	},
        	items: [{
        	     xtype: 'hidden',
        	     name: 'program'
        	},{
                xtype: 'textfield',
                fieldLabel: getCompletionModuleTranslation('PROGRAM'),            
                readOnly : true,
                submitValue: false,
                name: 'programName'
            }, {
            	 xtype: 'hidden',
         	     name: 'batch'
         	},{
                xtype: 'textfield',
                fieldLabel: getCompletionModuleTranslation('BATCH'),            
                readOnly : true,
                submitValue: false,
                name: 'batchName'
            }]
        }, {
        	 xtype: 'fieldcontainer',
             layout: 'hbox',
             defaults: {
                 labelAlign: 'top',
                 width: 256
             },
            items : [{
            	 xtype: 'hidden',
         	     name: 'seatType'
         	}, {
                xtype: 'textfield',
                fieldLabel: getCompletionModuleTranslation('SEAT_TYPE'),            
                readOnly : true,
                submitValue: false,
                name: 'seatTypeName'
            },{
                xtype: 'nestedJsonCombo',
                fieldLabel: getCompletionModuleTranslation('TRANSACTION_TYPE'),
                name: 'transactionType',
                itemId : 'checklistTransactionTypeCombo',
                store : 'completion.setup.TransactionTypes',
                valueField: 'id',
                displayField: 'translatedCode',  
                allowBlank: false,
                editable: false,
                queryMode: 'local'
            }]
        }, {
            xtype: 'itemselector',
            cls: 'itemSelectorCls',
            labelAlign: 'top',
            labelWidth: 120,
            margin : 0,
            width: 463,
            name: 'transactionTypeChecklistItems',
            itemId: 'checklistItems',
            fieldLabel: getCompletionModuleTranslation('CHECKLIST_ITEM'),
            maxHeight:500,
            autoScroll:true,
            allowBlank : false,
            imagePath: '../ux/css/images/',
            store: checkListStore,
            displayField: 'value',
            valueField: 'id',
            editable: false,
            fromTitle: getCompletionModuleTranslation('AVAILABLE_ITEM'),
            toTitle: getCompletionModuleTranslation('APPLICABLE_ITEM'),
            delimiter: null,
            buttons: ['top', 'add', 'remove', 'bottom'],
            style:{
            	marginLeft:'0px !important'
            }
        }, {
            xtype: 'itemselector',
            cls: 'itemSelectorCls',
            hidden: true,
            //submitValue: false,
            labelAlign: 'top',
            labelWidth: 120,
            margin: 0,
            width: 463,
            name: 'transactionTypeCertificates',
            itemId: 'certificates',
            fieldLabel: getCompletionModuleTranslation('CERTIFICATE'),
            maxHeight: 500,
            autoScroll: true,
            allowBlank : false,
            store: certificateStore,
            displayField: 'value',
            valueField: 'id',
            editable: false,
            fromTitle: getCompletionModuleTranslation('AVAILABLE_ITEM'),
            toTitle: getCompletionModuleTranslation('APPLICABLE_ITEM'),
            buttons: ['top', 'add', 'remove', 'bottom'],
            style:{
            	marginLeft:'0px !important'
            }
    	}, {
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SUBMIT'),
                itemId: 'itemSubmitButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }];
        this$.callParent(arguments);
    },
    buildCheckListStore: function() {
        return Ext.create('Academia.store.completion.setup.CKItemsMappedWithTransactionType');
    },
    buildCertificateStore: function() {
        return Ext.create('Academia.store.completion.setup.CertificatesMappedWithTransactionType');
    }
    
});