/**
 * @author Akshay Sharma
 */
Ext.define('Academia.view.course.NoOfCourseAcademyLocationWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.noofcourseacademylocationwindow',
	autoScroll: true,
	modal : true,
	height: '50%',
	width: '60%',
	title:getCommonTranslation('COURSE_ACADEMY_LOCATION_COUNT'),
	frame: true,
	items: [{
		xtype: 'courselinkdetails'
	}, {
		xtype: 'grid',
		border:true,
		store : 'course.academyLocation.MappedCourseAcademyLocationStore',
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'course.academyLocation.MappedCourseAcademyLocationStore',
				displayInfo : true
			} ]
		}],
		columns : [{
			header:  getCommonTranslation('ACADEMY_LOCATIONS'),
			dataIndex: 'wsAcademyLocation',
			flex: 1,
			sortable:true,
			renderer : function(value){
				var academy = value.academy;
				var location = value.location;
				if(academy!=null){
					return academy.academyName +'-'+ location.name;
				}
			}
		}]
	}]
});