/**
 * @author Akshay Sharma
 * @author Deepak Mathur
 * 
 */
Ext.define('Academia.view.course.StudentSendMessageWindowDashlet', {
	//extend: 'Ext.window.Window',
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.studentsendmessagewindowdashlet',
	modal: true,
	itemId : 'studentsendmessagewindowdashletId',
	autoScroll: true,
	frame: true,
	title: getMessagingModuleTranslation('ANNOUNCEMENT'),
	plugins: "formlabelrequired",
	items: [{
		xtype: 'form',
		itemId: 'msgDetailsForm',
		items: [{
			xtype:'hidden',
			name:'adhocMessageID',
			itemId:'adhocMessageID'
		},{
			xtype:'hidden',
			name:'adhocMessageStatus',
			itemId:'adhocMessageStatus'
		},{
			xtype:'hidden',
			name:'messageTemplates',
			itemId:'messageTemplates'
		},{    	    
			xtype:'hidden',
			name:'wsMsgEventRecipientConfigs',
			itemId:'wsMsgEventRecipientConfigs'	        		        		
		},{    	    
			xtype:'hidden',
			name:'wsAdhocRecipients',
			itemId:'wsAdhocRecipients'	        		        		
		},{
			xtype : 'hidden',
			name :'msgRecipientTypeId',
			itemId : 'msgRecipientTypeItemId'
		},{
			xtype : 'hidden',
			name: 'msgCategoryId',
			itemId: 'msgCategoryId'
		},{
			xtype : 'hidden',
			name: 'msgSubCategoryId',
			itemId: 'msgSubCategoryId'
		},{
			xtype : 'hidden',
			name: 'enquiryGridId',
			itemId: 'enquiryGridId'
		},{
			xtype : 'hidden',
			name: 'code',
			itemId: 'code'
		},{
			xtype : 'hidden',
			name: 'id',
			itemId: 'id'
		},{
			xtype : 'hidden',
			name: 'templateConfigName',
			itemId: 'templateConfigName'
		},{
			xtype : 'hidden',
			itemId : 'document_hidden_field',
			name : 'ids'
		}, {
			xtype : 'hidden',
			name : 'module'
		}, {
			xtype : 'hidden',
			name : 'entityId'
		}, {
			xtype : 'hidden',
			name : 'entityType'
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'radiogroup',
				//fieldLabel: getMessagingModuleTranslation('SENDING_PRIORITY'), //+' <span class="required" style="color:red"> *</span>',
				itemId: 'messageType',
				name:'messageTypeGroup',
				width: 500,
				labelAlign:'top',
				vertical: false,
				allowBlank : false,
				layout: {
					type: 'hbox'
				},
				items: [{
					boxLabel: getMessagingModuleTranslation('Adhoc Message'),
					itemId: 'adhocMessage',
					name: 'messageType',
					inputValue: 2,
					checked: true
				},{
					boxLabel: getMessagingModuleTranslation('Message Template'),
					itemId: 'messageTemplate',
					name: 'messageType',
					inputValue: 1
				}]
			}]},{

				xtype: 'fieldcontainer',
				layout: 'vbox',
				defaults: {
					labelAlign: 'top',
					width: 600,
					height: 65
				},
				items: [{
					   xtype: 'checkboxgroup',
			           fieldLabel: getCommonTranslation('SEND_TO'),
			           itemId: 'recieverType',
					   name: 'recieverType',
			           width: 600,    
			           allowBlank:false,
			           defaults : {
			           getSubmitData: function() {
			   	        var this$ = this,
			   	            data = null,
			   	            val;
			   	        if (!this$.disabled && this$.submitValue && !this$.isFileUpload()) {
			   	            val = this$.getSubmitValue();
			   	            if (val !== null) {
			   	            	//var customValue = "{\"id\":" + val + "}";
			   	            	var customValue = val;
			   	   	            val = Ext.decode(customValue);
			   	                data = {};
			   	   	            //data = [];
			   	                data[this$.getName()] = val;
			   	   	            //data.push(val);
			   	            }
			   	        }
			   	        return data;
			   	    }
			           },
			           items:[{
			        	   boxLabel:getCommonTranslation('STUDENT'),
			        	  inputValue : 1,
			        	  //itemId: 'adhocMessageStudent',
							//name: 'recieverType',
			        	   name:'recieverType'
			           },{
			        	   boxLabel:getCommonTranslation('PARENT'),
			        	   inputValue : 2,
			        	   //itemId: 'adhocMessageParent',
							//name: 'messageType',
			        	   name:'recieverType'
			           },{
			        	   boxLabel:getCommonTranslation('MYSELF'),
			        	   inputValue : 4,
			        	   checked: true,
			        	   name:'recieverType'
			           	}/*,{
			        	   boxLabel:getCommonTranslation('FEE_PAYER'),
			        	   inputValue : 3,
			        	   //itemId: 'adhocMessageFeePayer',
							//name: 'messageType',
			        	   name:'recieverType'
			           }*/]
				
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 256
				},
				items: [ {
					xtype: 'textfield',
					fieldLabel: getMessagingModuleTranslation('MESSAGE_ID'),
					name: 'messageId',
					itemId: 'messageId',
					emptyText: getCommonTranslation('ID_AUTOGENERATE'),
					readOnly:true,
					hidden: true,
				},{
					xtype: 'textfield',
					fieldLabel: getMessagingModuleTranslation('MESSAGE_NAME'),
					name: 'displayCode',
					itemId: 'messageName',
					allowBlank: false,
					hidden: true,
				}]},{
					xtype: 'fieldcontainer',
					width: '100%',
					layout: {
						type: 'vbox'
					},
					defaults: {
						labelAlign: 'top',
						width: 256
					},
					items: [{
						xtype: 'customcombobox',
						fieldLabel:  getMessagingModuleTranslation('SELECT_TEMPLATE'),                
						name: 'msgTemplateConfigId',
						emptyText :  getCommonTranslation('ENTER_THREE_CHAR'),      
						itemId : 'selectTemplate',   
						displayField : 'templateConfigName',
						valueField:'id',
						store:'messaging.MessagingTemplatesStore',
						allowBlank: false ,
						queryParam :'searchString', 
						hidden: true

					}]
				},{
					xtype: 'fieldcontainer',
					width: '100%',
					layout: {
						type: 'hbox'
					},
					defaults: {
						labelAlign: 'top',
						width: 256
					},
					items: [{
						xtype: 'customcombobox',
						fieldLabel:  getMessagingModuleTranslation('Select Message Type'),     // select Email or sms           
						name: 'msgTempletId',
						itemId : 'msgTempletId',   
						displayField : 'value',
						valueField:'id',
						store:'committee.committee.MessageTypeNotificationStore',
						allowBlank: false 

					},{
						xtype: 'textfield',
						//fieldLabel: getMessagingModuleTranslation('Subject')+':<span class="required" style="color:red">*</span>', 	// for subject
						fieldLabel: getMessagingModuleTranslation('Subject'),
						name: 'subjectDisplayCode',
						itemId: 'subject',
						allowBlank: false
					}]
				},{
					xtype: 'fieldcontainer',
					layout: 'vbox',
					defaults: {
						labelAlign: 'top',
						width: 440
					},
					items: [{
						xtype: 'textarea',
						fieldLabel: getMessagingModuleTranslation('Description'), 	// for subject
						name: 'smsDiscription',
						itemId: 'smsDiscription',
						maxLength: 900,
						hidden:true,
						height: 200
						// allowBlank: false
					},{
						xtype:'displayfield',
						name:'smsDiscriptionNotice',
						itemId:'smsDiscriptionNotice',
						//fieldLabel: '<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+'</span>',
						value: '<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE_CONSTANT')+'</span>',
						hidden:true,
						style:'padding-bottom:20px;'
					},{
						xtype: 'textarea',
						fieldLabel: getMessagingModuleTranslation('Description'), 
						name: 'pushNotificationDiscription',
						itemId: 'pushNotificationDiscription',
						maxLength: 1000,
						hidden:true,
						width: 462,
						height: 200
						// allowBlank: false
					},{
						xtype:'displayfield',
						name:'pushNotificationDiscriptionNotice',
						itemId:'pushNotificationDiscriptionNotice',
						value: '<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE_CONSTANT')+'</span>',
						hidden:true,
						style:'padding-bottom:20px;'
					},{
						xtype: 'ckeditor',
						itemId: 'discriptionId',
						name:'discriptionId',
						height: 400,
						width:700,
						maxLength: 9999999
					}]
				},{
					xtype: 'fieldcontainer',
					layout: 'vbox',
					defaults: {
						labelAlign: 'top',
						width: 256
					},
					items: [ {
						xtype : 'filefield',
						itemId : 'staticUploadFileField',
						hidden: true,
						width: 256,
						fieldLabel : getPersonModuleTranslation('SELECT_FILE'),
						ui : 'CustomBtnSubmit',
						buttonText : getPersonModuleTranslation('UPLOAD'),
						name : 'file'
					}]},{
						xtype: 'fieldcontainer',
						layout: 'vbox',
						itemId : 'studentdashletDocumentMessageAttachmentGrid',
						hidden: true,
						defaults: {
							labelAlign: 'top',
							width: 256
						},style:{
							marginLeft: '-18px'
						},							
						items: [{
							xtype : 'studentdashletstaticdocumentattachmentgrid',
							itemId : 'studentdashletStaticDocumentAttachmentGridMessage',
							width: 300
						}]
					},{
						xtype: 'fieldcontainer',
						layout: 'hbox',
						defaults: {
							labelAlign: 'top',
							width: 256
						},
						items: [{
							xtype: 'radiogroup',
							fieldLabel: getMessagingModuleTranslation('SENDING_PRIORITY'), //+' <span class="required" style="color:red"> *</span>',
							itemId: 'sendingPriority',
							name:'sendingPriority',
							width: 500,
							labelAlign:'top',
							vertical: false,
							allowBlank : false,
							layout: {
								type: 'hbox'
							},
							items: [{
								boxLabel: getMessagingModuleTranslation('IMMEDIATE'),
								itemId: 'immediate',
								name: 'sendingPriority',
								inputValue: 'IMMEDIATE',
								checked: true
							}, {
								boxLabel: getMessagingModuleTranslation('SCHEDULE'),
								itemId: 'schedule',
								name: 'sendingPriority',
								inputValue: 'SCHEDULE',
							}]
						}]
					},{
						xtype: 'fieldcontainer',
						width: '100%',
						style:{
							marginLeft: '3px',
							marginTop : '-7px'
						},
						layout: {
							type: 'hbox'
						},
						defaults: {
							labelAlign: 'top',
							width: 256
						},
						items: [{
							xtype: 'datefield',
							fieldLabel: getMessagingModuleTranslation('SCHEDULE_DATE'),
							name: 'msgDueDate',
							hidden: true,
							editable: false,
							itemId: 'scheduleDate',
//							format: CONSTANTS.DATE_FORMAT,
							minValue: new Date(),
							//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
							listeners: {
								render: function(field) {
									return dateFormatRender(field);
								},
								change : function(field) {
									var form = field.up('form');
									var scheduleTime = form.down("#scheduleTime");
									var msgDueDateVal = field.getValue();
									if(Ext.Date.format(msgDueDateVal, CONSTANTS.DATE_FORMAT) 
											== Ext.Date.format(new Date(), CONSTANTS.DATE_FORMAT))
										scheduleTime.setMinValue(new Date());
									else {
										scheduleTime.setMinValue(msgDueDateVal);
									}
								}
							}
						},{
							xtype: 'timefield',
							name: 'msgDueDateTime',
							itemId: 'scheduleTime',
							hidden: true,
							fieldLabel: getMessagingModuleTranslation('SCHEDULE_TIME'),
							format: CONSTANTS.DISPLAY_TIME_FORMAT,                
							increment: 30,
//							minValue:Ext.Date.format(new Date(),CONSTANTS.DISPLAY_TIME_FORMAT),
							editable: false
						}]        
					},{
						xtype: 'fieldcontainer',
						width: '100%',
						style :{
							marginLeft :'1px',
							marginTop :'19px'
						},
						items: [{
							xtype: 'button',
							text: getServiceRequestTranslation('SUBMIT'),
							itemId: 'adhocMsgSubmitBtn',
							buttonAlign: 'right',
							ui: 'CustomBtnSubmit',
							formBind : true,
							scale: CONSTANTS.BUTTONSIZE              
						}/*, {
								xtype: 'button',
								text: getServiceRequestTranslation('CANCEL'),
								ui: 'CustomBtnCancel',
								itemId: 'followUpDetailsCancelButtonId',
								scale: CONSTANTS.BUTTONSIZE,
								handler :function(button) {
									button.up('window').close();
								}
							}*/]
					}]
	}],
	
	updateCounter: function(textarea)
	{
		textarea.counterEl.update('' + 
				(textarea.maxLength - textarea.getValue().length));
	}	
});