/**
 * Rajkumar
 * 
 */
Ext.define('Academia.view.course.basicdetail.BasicDetailForm', {
   // extend: 'Ext.form.FormPanel',
	extend:'Academia.view.common.IdGeneratorCustomForm',
    //extend:'Academia.view.common.CustomForm',
	customFieldEntity:CONSTANTS.COURSE_CF_DATA,
    alias: 'widget.basicdetailform',
    columns: 3,
    title: getCommonTranslation('SUBJECT_DETAILS'),
    autoScroll: true,
	layout:'anchor',
	cls:'horizontalScrollingFixed x-form-fixed-footer-parent',
    frame: false,
    method: 'POST',
    standardSubmit: false,
	style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    defaults: {
		width: 256,
		labelAlign: 'top'
	},
	plugins : "formlabelrequired",
	items: [
		{
			xtype: 'hidden',
			itemId:'basicdeatilformId',
			name: 'id'
		},{
			xtype: 'hidden',
			name: 'version'
		},{
			xtype: 'hidden',
			name: 'whetherRepeatable1'
		},{
			xtype: 'hidden',
			name: 'deficiencyStatus1'
		},{
			xtype: 'hidden',
			name: 'hasCourseComponents1'
		},{
			xtype: 'hidden',
			name: 'sectionAtComponentLevel1'
		},{
			xtype: 'hidden',
			name: 'whetherEvaluationExternal1'   
		},{
			xtype: 'hidden',
			name: 'courseDeficits1'
			},/*{
	         xtype: 'hidden',
	         name: 'courseRankConsidered'
	    },*/{
	    	xtype: 'hidden',
	    	itemId:'course_sectionType',
	        name: 'sectionType'
	    },{
	    	xtype: 'hidden',
	    	itemId:'course_whetherFixed',
	        name: 'whetherFixed'
	    },{
	    	xtype: 'hidden',
	    	itemId:'whetherDeleted',
	        name: 'whetherDeleted'
	    },{
	    	xtype: 'hidden',
	    	itemId:'createdOn',
	        name: 'createdOn'
	    },{
			xtype: 'hidden',
			name: 'cId'
		},{
			xtype: 'hidden',
			name: 'simpleName'
		},{
	        xtype: 'hidden',
	        name: 'courseMultipleLanguageMap'
		},{
			xtype: 'fieldset',
			collapsible : true,
			collapsed: false,
			title: getCommonTranslation('COURSE_BASIC_DETAILS'),
			titleCollapse: true,
			margin: '0 0 0 0',
			padding: '0 0 0 0',
			width: '100%',
			itemId : 'courseBasicDetailsItemId',
			style: {
				marginTop: '33px!important'
			},
			items: [
				{
					xtype:'fieldcontainer',
					layout:'hbox',
					width:'100%',
					defaults: {
						width: 256,
						labelAlign: 'top'
					},
					items:[{
						xtype: 'textfield',
						name: 'courseCode',
						itemId:'courseCode',
						readOnly:false,
						fieldLabel: getCommonTranslation('COURSE_CODE'),
						maxLength:50,
						enforceMaxLength : true,
						maxLengthText : getCommonTranslation('COURSE_CODE_MSG'),
						allowBlank:false
					},{
						xtype: 'textfield',
						name: 'courseCodeToBePrinted',
						maxLength:50,
						fieldLabel: getCommonTranslation('COURSE_CODE_TO_BE_PRINTED'),
						allowBlank:false                       
					},{
						xtype: 'textfield',
						name: 'courseName',
						itemId:'courseNameItemId',
						fieldLabel: getCommonTranslation('COURSE_NAME'),
						allowBlank:false,
						maxLength:255
					}]
				}, {
					xtype:'fieldcontainer',
					layout:'hbox',
					width:'100%',
					defaults: {
						width: 256,
						labelAlign: 'top'
					},
					items:[{
							xtype: 'textfield',
							name: 'nameToBePrinted',
							fieldLabel: getCommonTranslation('NAME_TO_PRINTED'),
							allowBlank:false,
							maxLength:255
						},{
							xtype: 'textfield',
							name: 'courseShortName',
							readOnly:false,
							fieldLabel: getCommonTranslation('COURSE_SHORT_NAME'),
							maxLength:255
						},{
							xtype: 'customcombobox',
							name: 'courseCategory',
							itemId:'courseCategory',
							fieldLabel: getProgramandcourseTranslation('COURSE_CATEGORY'),
							store:'course.CourseCategoryStore',
							displayField:'value',
							valueField:'id',
							queryParam:'qry',
							minChars:3,
							emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
							forceSelection:true,
							typeAhead: false,
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								},
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function() {
									return '<div class="search-item">' +
									'{value}' +
									'</div>';
								}
							}
						}
					]
				}, {
					xtype:'fieldcontainer',
					layout:'hbox',
					width:'100%',
					defaults: {
						width: 256,
						labelAlign: 'top'
					},
					items:[{
							xtype: 'textfield',
							name: 'courseNameLanguageOne',
							itemId:'courseNameLanguageOneId',
							fieldLabel: getCommonTranslation('COURSE_NAME_LANGUAGE_ONE'),
							allowBlank: true                      
						},{
							xtype: 'textfield',
							name: 'courseShortNameLanguageOne',
							itemId:'courseShortNameLanguageOneId',
							fieldLabel: getCommonTranslation('COURSE_SHORT_NAME_LANGUAGE_ONE'),
							allowBlank:true
						},{
							xtype: 'textfield',
							name: 'nameToBePrintedLanguageOne',
							itemId:'nameToBePrintedLanguageOneId',
							fieldLabel: getCommonTranslation('NAME_TO_PRINT_LANGUAGE_ONE'),
							allowBlank: true
						} 
					]
				}, {
					xtype:'fieldcontainer',
					layout:'hbox',
					width:'100%',
					defaults: {
						width: 256,
						labelAlign: 'top'
					},
					items:[{
							xtype: 'textfield',
							name: 'courseNameLanguageTwo',
							itemId:'courseNameLanguageTwoId',
							allowBlank:true,
							fieldLabel: getCommonTranslation('COURSE_NAME_LANGUAGE_TWO')                      
						},{
							xtype: 'textfield',
							name: 'courseShortNameLanguageTwo',
							itemId:'courseShortNameLanguageTwoId',
							fieldLabel: getCommonTranslation('COURSE_SHORT_NAME_LANGUAGE_TWO'),
							allowBlank: true
						},{
							xtype: 'textfield',
							name: 'nameToBePrintedLanguageTwo',
							itemId:'nameToBePrintedLanguageTwoId',
							fieldLabel: getCommonTranslation('NAME_TO_PRINT_LANGUAGE_TWO'),
							allowBlank: true
						} 
					]
				}, {
					xtype:'fieldcontainer',
					layout:'hbox',
					width:'100%',
					defaults: {
						width: 256,
						labelAlign: 'top'
					},
					items:[{
							xtype: 'textfield',
							name: 'courseNameLanguageThree',
							itemId:'courseNameLanguageThreeId',
							fieldLabel: getCommonTranslation('COURSE_NAME_LANGUAGE_THREE'),
							allowBlank:true                       
						},{
							xtype: 'textfield',
							name: 'courseShortNameLanguageThree',
							itemId:'courseShortNameLanguageThreeId',
							fieldLabel: getCommonTranslation('COURSE_SHORT_NAME_LANGUAGE_THREE'),
							allowBlank:true 
						},{
							xtype: 'textfield',
							name: 'nameToBePrintedLanguageThree',
							itemId:'nameToBePrintedLanguageThreeId',
							fieldLabel: getCommonTranslation('NAME_TO_PRINT_LANGUAGE_THREE'),
							allowBlank: true
						} 
					]
				}, {
					xtype:'panel',
					itemId:'panelIdH',
					layout : 'vbox',
					width: '100%',
					margin: '0 0 0 0',
					padding: '0 0 0 0',
					style:{
						marginLeft:'0px',
						marginTop:'0px'
					},
				items:[{
						xtype : 'fieldcontainer',
						layout : 'hbox',
						width: '100%',
						defaults : {
							labelAlign : 'top',
							width: '256'
						},
						layout : {
							type : 'hbox'
						},
						margin: '0 0 0 0',
						padding: '0 0 0 0',
						items:[{
								xtype: 'customcombobox',
								width: 256,
								name: 'departmentName',
								itemId:'departmentId',
								store: Ext.create('Academia.store.course.CourseDepartmentStore'),
								fieldLabel: getCommonTranslation('COURSE_DEPARTMENT'),
								valueField: 'id',
								displayField: 'value',
								allowBlank: false,
								typeAhead: false,
								queryParam:'qry',
								minChars:3,
								rowIndx:0,
								emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
								forceSelection:true,
								listConfig: {
									listeners: {
										beforeshow: function(picker) {
											picker.minWidth = picker.up('combobox').getSize().width;
										}
									},
									loadingText: getCommonTranslation('SEARCHING'),
									emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
									getInnerTpl: function() {
										return '<div class="search-item">' +
										'{value}' +
										'</div>';
									}
								}
							},
						{
							xtype: 'customcombobox',
							name: 'subDepartmentName',
							itemId: 'subDepartmentId',
							fieldLabel: getCommonTranslation('COURSE_SUB_DEPARTMENT'),
							disabled: true,
							editable: false,
							queryMode: 'local',
							valueField: 'id',
							displayField: 'value',
							width: 256,
							listeners: {
								render: function(combo) {
									var store = Ext
									.create('Academia.store.course.CourseSubDepartmentStore');
									combo.bindStore(store);
								}
							}
						},
						{    
							xtype: 'numberfield',
							itemId:'weightageId',
							name: 'weightage',
							fieldLabel: getCommonTranslation('DEPARTMENT_WEIGHTAGE_IN_PERCENTAGE'),
							minValue : 1,
							maxValue:100,
							maxLength: 3,
							allowBlank:false,
							allowExponential:false,
							keyNavEnabled: false,
							mouseWheelEnabled: false,
						},{
							xtype: 'hidden',
							name: 'courseDepartmentId',
						},
						{
							xtype: 'button',
							itemId: 'addDetailedBtn',
							name: 'addDetailedBtn',
							width: 'auto',
							cls: 'CustomBodyBtnSettings',
							width: 'auto',
							text: getCommonTranslation('ADDBUTTONTEXT'),
							tooltip: getCommonTranslation('ADD'),
							style:{
								marginTop:'30px',
								marginLeft:'10px'
							}
						}]
					}
				]
				},{

		    		xtype:'panel',
		    		itemId:'panelMSP',
		    		layout : 'vbox',
		    		width: '100%',
		    		margin: '0 0 0 0',
		    		padding: '0 0 0 0',
		    		style:{
		    			marginLeft:'0px',
		    			marginTop:'0px'
		    		},
		    		items:[{
		    			xtype : 'fieldcontainer',
		    			layout : 'hbox',
		    			width: '100%',
		    			defaults : {
		    				labelAlign : 'top',
		    				width: '256'
		    			},
		    			layout : {
		    				type : 'hbox'
		    			},
		    			margin: '0 0 0 0',
		    			padding: '0 0 0 0',
		    			items:[{
		    				xtype: 'customcombobox',
		    				width: 256,
		    				name: 'moduleSubject',
		    				itemId:'moduleSubjectId',
		    				store: Ext.create('Academia.store.program.programDetails.programSubjects.FindAllHesaSubjectComboStore'),
		    				fieldLabel: getCommonTranslation('MODULE_SUBJECTS'),
		    				valueField: 'id',
		    				displayField: 'value',
		    				hidden:true,
		    				allowBlank: true,
		    				typeAhead: false,
		    				queryParam:'qry',
		    				rowIndx:0,
		        			minChars:3,
		                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		                    forceSelection:true,
		        			  listConfig: {
		        				  listeners: {
		        						beforeshow: function(picker) {
		        							picker.minWidth = picker.up('combobox').getSize().width;
		        						}
		        					},
		        	                loadingText: getCommonTranslation('SEARCHING'),
		        	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		        	                getInnerTpl: function() {
		        	                    return '<div class="search-item">' +
		        	                        '{value}' +
		        	                    '</div>';
		        	                }
		        	            }
		    			},{    
		    				xtype: 'numberfield',
		    				itemId:'moduleSubjectsProportionId',
		    				name: 'moduleSubjectsProportion',
		    				fieldLabel: getCommonTranslation('MODULE_SUBJECTS_PROPORTION'),
		    				minValue : 1,
		    				maxValue:100,
		    				maxLength: 3,
		    				hidden:true,
		    				disabled:true,
		    				allowBlank:true,
		    				allowExponential:false,
		    				keyNavEnabled: false,
		    				mouseWheelEnabled: false,
		    			},
		    			{
		    				xtype: 'button',
		    				itemId: 'addDetailedMSPBtn',
		    				name: 'addDetailedMSPBtn',
		    				width: 'auto',
		    				hidden:true,
		    				cls: 'CustomBodyBtnSettings',
		    				width: 'auto',
		    				text: getCommonTranslation('ADDBUTTONTEXT'),
		    				tooltip: getCommonTranslation('ADD'),
		    				style:{
		    					marginTop:'30px',
		    					marginLeft:'10px'
		    				}
		    			}]
		    		}]
		    				
				}, {
					xtype:'fieldcontainer',
					layout:'hbox',
					width:'100%',
					defaults: {
						width: 256,
						labelAlign: 'top'
					},
					items:[{
						xtype: 'customcombobox',
						name: 'selectionStage',
						itemId:'stage_Type',
						fieldLabel: getCommonTranslation('STAGE_TYPE'),
						store:Ext.create('Academia.store.examinationcenters.CenterUseFor'),
						displayField:'value',
						valueField:'id',
						allowBlank: false	

					},{
						xtype: 'customcombobox',
						itemId:'courseCoordinator',
						name:'user',
						store:'course.CourseCoordinatorSmartSearch',
						fieldLabel: getCommonTranslation('COURSE_CO_ORDINATOR'),
						valueField: 'id',
						displayField: 'value',
						queryParam:'codeOrName',
						minChars:3,
						typeAhead:false,
						triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
						enableKeyEvents  : 'true',
						hideTrigger:false,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						triggerAction: '',
						forceSelection:true,
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}' +
								'</div>';
							}
						}
					},{	
						xtype : 'numberfield',
						name: 'courseCredits',
						itemId:'courseCredit_Id',
						fieldLabel: getCommonTranslation('COURSE_CREDITS'),
						//minValue : 0,
						allowDecimals:true,
						minValue:0,
						decimalPrecision: 2
					},{	
						xtype : 'textfield',
						name: 'courseCreditsNBC',
						itemId:'courseCredit_IdNBC',
						fieldLabel: getCommonTranslation('COURSE_CREDITS'),
						hidden:true,
						readOnly:false
						
					  }
					
				]
				}, {
					xtype:'fieldcontainer',
    	        			width: 'auto',
    	        			layout : {
    	        				type : 'hbox'
    	        			},
    	        			defaults : {
    	        				width: 256,
    	        				labelAlign : 'top'
    	        			},
    	        			items : [{	
        						xtype : 'numberfield',
        						name: 'ectsCredits',
        						itemId:'ectsCredits',
        						fieldLabel: getCommonTranslation('ECTS_CREDITS'),
        						//minValue : 0,
        						allowDecimals:true,
        						hidden:true,
        						minValue:0,
        						decimalPrecision: 2
        					},{	
        						xtype : 'textfield',
        						name: 'ectsCreditsNBC',
        						itemId:'ectsCreditsNBC',
        						fieldLabel: getCommonTranslation('ECTS_CREDITS'),
        						hidden:true,
        						readOnly:false
        						
        					  },{
    	        		            fieldLabel: getCommonTranslation('COURSE_SEQUENCE'), //Contact No.
    	        		            xtype: 'numberfield',
    	        		            itemId: 'courseSequenceId',
    	        		            name: 'courseSequence',
    	        		            minValue: 0,
    	        		            labelAlign: 'top',
    	        		            style:{marginBottom:'2px'},
    	        		            maxLength: 3,
    	        		            allowExponential :false,
    	        					allowDecimals: false,
    	        		            mouseWheelEnabled:false,
    	        		            hideTrigger: true,

    	        				},{
                                    xtype: 'customcombobox',
                                    name: 'succeedingCourse',
                                    itemId:'succeedingCourseId',
                                    fieldLabel: getCommonTranslation('SUCCEEDING_COURSE'),
                                    store: Ext.create('Academia.store.course.succeedingCourseStore'),
                                    displayField:'valueCode',
                                    valueField:'id',
                                    forceSelection:true,
                                    autoloadStore: false,
                                    editable: false,
                                    matchFieldWidth:true,
                                    listConfig: {
                                        listeners: {
                                            beforeshow: function(picker) {
                                                picker.width = picker.up('combobox').getSize().width;
                                            }
                                        },
                                        getInnerTpl: function() {
                                            return '<div class="search-item">' +
                                            '{moduleDesc} / {moduleName}' +
                                            '</div>';
                                        }
                                    }
                                },{
    	        		            fieldLabel: getCommonTranslation('MODULE_HEQSF_LEVEL'), //Contact No.
    	        		            xtype: 'numberfield',
    	        		            itemId: 'moduleHEQSFLevelId',
    	        		            name: 'moduleHEQSFLevel',
    	        		            minValue: 0,
    	        		            maxLength:5,
    	        		            labelAlign: 'top',
    	        		            style:{marginBottom:'2px'},
    	        		            allowExponential :false,
    	        					allowDecimals: false,
    	        		            mouseWheelEnabled:false,
    	        		            hideTrigger: true,

    	        				}
    	        			]},{
    						xtype:'fieldcontainer',
					layout:'hbox',
					width:'100%',
					defaults: {
						width: 256,
						labelAlign: 'top'
					},
					items:[{
						xtype : 'customcombobox',
						name: 'courseCESMCode',
						itemId: 'courseCESMCodeId',
						fieldLabel: getCommonTranslation('COURSE_CESM_CODE'),
						store: Ext.create('Academia.store.course.CourseCESMCodeStoreFromCSM'),
						allowBlank:true,
						valueField: 'id',
						displayField: 'value',
					},{
						xtype: 'customcombobox',
						name: 'courseNQFLevel',
						itemId: 'courseNQFLevelId',
						allowBlank:true,
						fieldLabel: getCommonTranslation('COURSE_NQF_LEVEL'),
						store:Ext.create('Academia.store.course.CourseNQFLevelStoreFromCSM'),
						editable: false,
						valueField: 'id',
						displayField: 'value',
						forceSelection:true
					},{
						xtype: 'customcombobox',
						name: 'subjectType',
						itemId:'subjectType_Id',
						fieldLabel: getCommonTranslation('SUBJECT_TYPE'),
						store: 'course.CourseSubjectTypeStore',
						editable: true,
						valueField: 'id',
						displayField: 'value',
						allowBlank: true,
						forceSelection:true
					} 
				]
				}, {
					xtype:'fieldcontainer',
					layout:'hbox',
					width:'50%',
					defaults: {
						width: 256,
						labelAlign: 'top'
					},
					items:[{
					    xtype: 'numberfield',
					    name: 'weightGPA',
						itemId: 'weightGPA',
					    fieldLabel: getCommonTranslation('WEIGHT_GPA'),
					    allowDecimals: true,
					    hidden: true,
					    minValue:0,
					    maxValue:999999,
					    editable: true,
					    decimalPrecision: 2, // for display purposes only
					    validator: function(value) {
					        if (value === '' || value === null) {
					            return true; // allow blank if required
					        }

					        // Check if the value has more than 2 decimal digits
					        var parts = value.toString().split('.');
					        if (parts.length === 2 && parts[1].length > 2) {
					            return 'Only up to two decimal places are allowed.';
					        }
					        return true;
					    }
					}
				]}
				,{
					xtype : 'fieldcontainer',
					width: 'auto',
					layout : {
						type : 'hbox'
					},
					defaults : {
						width: 256,
						labelAlign : 'top'
					},
					items : [{
						xtype : 'radiogroup',
						itemId:'isLMSCoursesId',
						name:'isLMSCourses',
						fieldLabel : getCommonTranslation('LMS_COURSE'),
						height:60,
						defaults: {
							flex: 1
						},
						items: [{
							boxLabel  : getCommonTranslation('YES'),
							name      : 'isLMSCourses',
							inputValue: true
						},{
							boxLabel  : getCommonTranslation('NO'),
							name      : 'isLMSCourses',
							inputValue: false,
							checked   : true		                     
						}]
					},{
						xtype: 'numberfield',
						name: 'lMSCourseOfferYear',
						itemId: 'lMSCourseOfferYearItemId',
						fieldLabel: getCommonTranslation('LMS_COURSE_OFFER_YEAR'),
						allowBlank: true,
						minValue : 0,
						maxLength: 5,
						hidden:true,
						allowExponential:false,
						keyNavEnabled: false,
						mouseWheelEnabled: false,
					},{
						xtype: 'checkboxfield',
						itemId : 'isPublishToLMS',
						labelAlign: 'right',
						region: 'south',
						hidden:true,
						boxLabel: getCommonTranslation('PUBLISH_TO_LMS'),
						name: 'isPublishToLMS',
						inputValue: true,
						checked: false
					},{
						xtype: 'radiogroup',
						fieldLabel: getCommonTranslation('IS_FEE_APPLICABLE'),
						itemId: 'isFeeApplicable',
						height:60,
						name: 'isFeeApplicable',
						defaults: {
							flex: 1
						},
						layout: 'hbox',
						items:[{ 
							boxLabel: getCommonTranslation('YES'),
							name:'isFeeApplicable',
							inputValue: true 
						},{ 
							boxLabel: getCommonTranslation('NO'), 
							name:'isFeeApplicable',
							inputValue: false,
							checked:true
						}]
					},
					{
						xtype: 'radiogroup',
						fieldLabel: getCommonTranslation('HYBRID_COURSE'),
						itemId: 'hybridModule',
						height:60,
						name: 'hybridModule',
						defaults: {
							flex: 1
						},
						layout: 'hbox',
						items:[{ 
							boxLabel: getCommonTranslation('YES'),
							name:'hybridModule',
							inputValue: true 
						},{ 
							boxLabel: getCommonTranslation('NO'), 
							name:'hybridModule',
							inputValue: false,
							checked:true
						}]
					},
					
				]
			}, {
				xtype : 'fieldcontainer',
				width: 'auto',
				layout : {
					type : 'hbox'
				},
				defaults : {
					width: 256,
					labelAlign : 'top'
				},
				items : [
					{
						xtype : 'textarea',
						width: 536,
						name: 'courseShortDescription',
						allowBlank:false,
						fieldLabel: getCommonTranslation('COURSE_SHORT_DESCRIPTION'),
						enforceMaxLength : true,
						maxLength:225

					},{
						xtype: 'multiselectcombofield',
						name: 'multipleLanguage',
						cls: 'ProgramCourseMultiselectField',
						itemId: 'multipleLanguageId',
						fieldLabel : getProgramandcourseTranslation('LANGUAGE_OPTION'),
						store:Ext.create('Academia.store.common.MultiLanguageStore'),
						displayField:'value',
						valueField:'id',
						editable:false,
						matchFieldWidth:true,
						typeAhead : false,
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.width = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{code}' +
								'</div>';
							}
						}

					}
				]
			},   {
            			xtype : 'fieldcontainer',
            			width: 'auto',
            			layout : {
            				type : 'hbox'
            			},
            			defaults : {
            				width: 256,
            				labelAlign : 'top'
            			},
            			items : [
        			{
        				xtype : 'textarea',
        				width: 536,
        				name: 'courseShortDescriptionInOtherLanguage',
        				allowBlank:true,
        				fieldLabel: getCommonTranslation('COURSE_SHORT_DESCRIPTION_IN_OTHER_LANGUAGE'),
        				enforceMaxLength : true,
        				maxLength:225

        			},{
        				xtype: 'textfield',
    			        name: 'subjectAdditionalCode',
    			        readOnly:false,
    			        fieldLabel: getCommonTranslation('SUBJECT_ADDITIONAL_CODE'),
    			        maxLength:5

        			}]},
                    {
            			xtype : 'fieldcontainer',
            			width: 'auto',
            			layout : {
            				type : 'hbox'
            			},
            			defaults : {
            				width: 256,
            				labelAlign : 'top'
            			},
            			items : [
	                    {
	        	xtype: 'customcombobox',
	            name: 'metaCourseOne',
	            itemId:'metaCourseOne',
	            fieldLabel: getCommonTranslation('META_COURSE_1'),
	            store: Ext.create('Academia.store.common.MetaCourseStore'),
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            editable: false,
	            matchFieldWidth:true,
	            listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					}
	            }
			}
        		,  {
	        	xtype: 'customcombobox',
	            name: 'metaCourseTwo',
	            itemId:'metaCourseTwo',
	            fieldLabel: getCommonTranslation('META_COURSE_2'),
	            store: Ext.create('Academia.store.common.MetaCourseStore'),
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            editable: false,
	            matchFieldWidth:true,
	            listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					}
	            }
			},  {
	        	xtype: 'customcombobox',
	            name: 'metaCourseThree',
	            itemId:'metaCourseThree',
	            fieldLabel: getCommonTranslation('META_COURSE_3'),
	            store: Ext.create('Academia.store.common.MetaCourseStore'),
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            editable: false,
	            matchFieldWidth:true,
	            listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					}
	            }
			}	]}, {
				xtype:'fieldcontainer',
				layout:'hbox',
				width:'100%',
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items:[{
					xtype: 'radiogroup',
					fieldLabel: getCommonTranslation('MODULE_PREREQUISITES'),
					itemId:'modulePrerequisitesRadioItemId',
					name:'modulePrerequisitesRadio',
					defaults: {
						flex: 1
					},
					layout: 'hbox',
					items:[
						{
							boxLabel:getCommonTranslation('YES'), 
							name: 'modulePrerequisitesRadio', 
							inputValue: 1, 
							checked : true 
						},
						{ 
							boxLabel:getCommonTranslation('NO'), 
							name: 'modulePrerequisitesRadio', 
							inputValue: 0 
						}
						]		    	
				},{
					xtype:'checkbox',
					name: 'isPublishInCatalogue',
					boxLabel: getProgramandcourseTranslation('PUBLISH_IN_CATALOGUE'),
					itemId:'publishInCatalogueId',
					inputValue: true,
					uncheckedValue: false,
					style:{marginTop: '28px !important'},
					},{
						xtype: 'radiogroup',
						fieldLabel: getCommonTranslation('ELIGIBLE_TRANSFER_CREDIT'),
						itemId: 'eligibleTransferCredit',
						height:60,
						name: 'eligibleTransferCredit',
						hidden: true,
						defaults: {
							flex: 1
						},
						layout: 'hbox',
						items:[{ 
							boxLabel: getCommonTranslation('YES'),
							name:'eligibleTransferCredit',
							inputValue: true 
						},{ 
							boxLabel: getCommonTranslation('NO'), 
							name:'eligibleTransferCredit',
							inputValue: false,
							checked:true
						}]
					}]
			}, {
				xtype:'fieldset',
				layout:'hbox',
				width:'100%',
				cls: 'modulePrerequisitesFieldsetCls',
				itemId: 'modulePrerequisitesFieldsetItemId',
				defaults: {
					width: 536,
					labelAlign: 'top'
				},
				title: getCommonTranslation('MODULE_PREREQUISITES')+ ":",
				style: {
					marginTop: '28px !important',
					padding:'0 !important'
				},
				items:[{
					xtype: 'ckeditor',
					itemId: 'modulePrerequisiteId',
					name:'modulePrerequisite',
					cls: 'ckEditorCls',
					height: 400,
					width:700,
					maxLength: 5000,
					enforceMaxLength : true,
					allowBlank:true
				}]
			}
		]
	}, {
		xtype: 'fieldset',
		collapsible : true,
		collapsed: true,
		title: getCommonTranslation('COURSE_SECTION_DETAILS'),
		titleCollapse: true,
		margin: '0 0 0 0',
		padding: '0 0 0 0',
		width: '100%',
		itemId : 'courseSelectionDetailsItemId',
		style: {
			marginTop: '33px!important'
		},
		items: [{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'customcombobox',
				name : 'assignSectionType',
				itemId:'assignSectionTypeId',
				fieldLabel : getCommonTranslation('SECTION_TYPE'),		
				store:Ext.create('Academia.store.course.SectionTypeStore'),
				valueField : 'id',
				displayField : 'value',
				triggerAction : 'all',
				editable : false,
				allowBlank : true,
				value:"PROGRAM_BATCH_SECTION"
			},{
				xtype: 'radiogroup',
				fieldLabel: getCommonTranslation('HAS_COURSE_COMPONENT'),
				itemId:'hasCourseComponents_id',
				name:'hasCourseComponents',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[
					{ boxLabel:getCommonTranslation('YES'), name: 'hasCourseComponents', inputValue: 1, checked : true },
					{ boxLabel:getCommonTranslation('NO'), name: 'hasCourseComponents', inputValue: 0 }
					]		    	
			},{
				xtype: 'radiogroup',
				fieldLabel: getCommonTranslation('CREATE_SECTION_AT_COMPONENT_LEVEL'),
				itemId:'sectionAtComponentLevel_id',
				name:'sectionAtComponentLevel',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[
					{ boxLabel:getCommonTranslation('YES'), name: 'sectionAtComponentLevel', inputValue: 1},
					{ boxLabel:getCommonTranslation('NO'), name: 'sectionAtComponentLevel', inputValue: 0, checked : true}
					]
			}]
		},{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'radiogroup',
				itemId:'repeatablePeriods_Id',
				name:'whetherRepeatable',
				fieldLabel : getCommonTranslation('REPEATABLE_IN_MULTIPLE_PRIODS'),
				disabled:true,
				defaults: { flex: 1},
				layout: 'hbox',
				items: [{
					boxLabel  : getCommonTranslation('YES'),
					name      : 'whetherRepeatable',
					inputValue: true
				},{
					boxLabel  : getCommonTranslation('NO'),
					name      : 'whetherRepeatable',
					inputValue: false,
					checked : true
				}]
			},{
				xtype: 'customcombobox',
				name:'CalculationRule',
				store:Ext.create('Academia.store.examinationcenters.evaluation.applyrule.CalculationBussinessRule'),
				itemId:'calcualtionRuleId',
				fieldLabel: getExaminationTranslation('CALCULATION_RULE'),
				displayField: 'value',
				valueField: 'id',
				typeAhead: true,
				forceSelection: true,
				hidden: true
			}]

		}]
	},{
		xtype: 'fieldset',
		collapsible : true,
		collapsed: true,
		title: getCommonTranslation('COURSE_ASSESSMENT_DETAILS'),
		titleCollapse: true,
		margin: '0 0 0 0',
		padding: '0 0 0 0',
		width: '100%',
		itemId : 'courseAssessmentDetailsItemId',
		style: {
			marginTop: '33px!important'
		},
		items: [{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				width: 227,
				labelAlign: 'top'
			},
			items:[{
				xtype : 'customcombobox',
				name : 'courseMarkGrad',
				itemId:'courseMarksGrades_id',
				fieldLabel : getCommonTranslation('COURSE_MARK_GRADES'),	
				store:Ext.create('Academia.store.course.CourseMarkGradeStore'),
				valueField : 'id',
				displayField : 'value',
				triggerAction : 'all',
				editable : false,
				allowBlank : false
			},
			{
				xtype: 'numberfield',
				itemId:'courseOff_id',
				name: 'courseCutOff',
				fieldLabel: getCommonTranslation('COURSE_MINIMUM_PASSING_MARKS'),
				minValue : 0,
				minText:getCommonTranslation('COURSE_DEFICITS_POINT_MSG'),
				hidden:true,
				allowBlank : false
			},
			{
				xtype: 'customcombobox',
				itemId:'courseMax_1',
				fieldLabel : getCommonTranslation('COURSE_GRADES'),
				name:'courseMaxMarkCombo',
				store:Ext.create('Academia.store.course.CourseGradeStore'),
				displayField: 'value',
				valuefield:'value',
				hidden:true,
				allowBlank : false
			},{    
				xtype: 'numberfield',
				itemId:'courseMaxMarks_Id',
				name: 'courseMaxMark',
				fieldLabel: getCommonTranslation('COURSE_MAXIMUM_PASSING_MARKS'),
				minValue : 1,
				minText:getCommonTranslation('COURSE_DEFICITS_POINT_MSG'),
				hidden:true,
				allowBlank : false	
			},{
				xtype: 'customcombobox',
				itemId:'courseOff_1',
				fieldLabel : getCommonTranslation('COURSE_MINIMUM_PASSING_GRADE'),
				name:'courseCutOffComboMin',
				store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
				displayField: 'gradeName',
				valuefield:'gradeName',
				hidden:true,
				forceSelection:true,
				allowBlank : false
			}

			]    
		},{	
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			//id:'fieldcontainerMax',
			defaults: {
				width: 227,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				itemId:'courseOff_2',
				fieldLabel : getCommonTranslation('COURSE_MAXIMUM_PASSING_GRADE'),
				name:'courseCutOffComboMax',
				store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
				displayField: 'gradeName',
				valuefield:'gradeName',
				forceSelection:true,
				hidden:true,
				allowBlank:false
			}

			]   


		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{    
				xtype: 'radiogroup',
				itemId:'courseRank_Id',
				name:'courseRankConsidered',
				fieldLabel: getCommonTranslation('COURSE_RANK_CONSIDERED') ,
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[
					{ boxLabel: getCommonTranslation('YES'), name: 'courseRankConsidered', inputValue: 'Y',checked : true },
					{ boxLabel: getCommonTranslation('NO'), name: 'courseRankConsidered', inputValue: 'N'}
					]    		
			} ,

			{
				xtype: 'radiogroup',
				fieldLabel: getCommonTranslation('CONSIDER_FOR_PROMOTION') ,  //getCommonTranslation('HAS_COURSE_COMPONENT'),
				itemId:'includeinPromotion',
				name:'includeinPromotion',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[
					{ boxLabel:getCommonTranslation('YES'), name: 'includeinPromotion', inputValue: 1, checked : true },
					{ boxLabel:getCommonTranslation('NO'), name: 'includeinPromotion', inputValue: 0 }
					]		    	
			},{

				xtype : 'radiogroup',
				itemId:'whetherEvaluationExternalItemId',
				name:'whetherEvaluationExternal',
				fieldLabel : getCommonTranslation('COURSE_EXTERNAL_EVALUTION'),
				height:60,
				defaults: {
					flex: 1
				},
				items: [{
					boxLabel  : getCommonTranslation('YES'),
					name      : 'whetherEvaluationExternal',
					inputValue: true,
					checked   : true
				},{
					boxLabel  : getCommonTranslation('NO'),
					name      : 'whetherEvaluationExternal',
					inputValue: false		                     
				}]

			}]    	
		} ,{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'radiogroup',
				width:400,
				name:'whetherCourseExemption',
				itemId:'whetherCourseExemptionItemId',
				hidden:true,
				fieldLabel: getCommonTranslation('WHETHER_COURSE_EXEMPTION'),
				items:[
					{ boxLabel:getCommonTranslation('YES'), name: 'whetherCourseExemption', inputValue: 1},
					{ boxLabel:getCommonTranslation('NO'), name: 'whetherCourseExemption', inputValue: 0, checked : true}
					]		    	
			},{
				xtype: 'radiogroup',
				itemId:'course_Deficiency_Status_Id',
				name:'deficiencyStatus',
				fieldLabel: getCommonTranslation('DEFICIENCY_STATUS'),
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items:[
					{ boxLabel:getCommonTranslation('YES'), name: 'deficiencyStatus', inputValue: true },
					{ boxLabel:getCommonTranslation('NO'), name: 'deficiencyStatus', inputValue: false ,checked:true }
					]
			},{
				xtype: 'customcombobox',
				itemId:'course_Deficits_Id',
				name:'courseDeficits',
				fieldLabel: getCommonTranslation('COURSE_DEFICITS'),
				store:'course.CourseDeficitsStore',
				displayField: 'value',
				valuefield:'id',
				forceSelection:true,
				hidden:true,
				editable:false,
				typeAhead: false,
				value:getCommonTranslation('FIXED')
			},{
				xtype : 'numberfield',
				name: 'courseDeficitsPoint',
				itemId:'course_Deficits_Point_Id',
				hidden:true,
				fieldLabel: getCommonTranslation('COURSE_DEFICITS_POINT'),
				minValue : 0,
				maxLength:10,
				allowDecimals:false,
				minText:getCommonTranslation('COURSE_DEFICITS_POINT_MSG')

			}]},{
				xtype:'fieldcontainer',
				layout:'hbox',
				width:'100%',
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items:[
					{
						xtype: 'customcombobox',
						name:'CalculationRule',
						store:Ext.create('Academia.store.examinationcenters.evaluation.applyrule.CalculationBussinessRule'),
						itemId:'calcualtionRuleId',
						fieldLabel: getExaminationTranslation('CALCULATION_RULE'),
						displayField: 'value',
						valueField: 'id',
						typeAhead: true,
						forceSelection: true,
						hidden: true
					}]}    	
			]
		},
		{
			xtype:'coursedocumentgrid',
			hidden:true
		},{ 
			xtype:'fieldcontainer',
			cls: 'form-fixed-footer',
			width:'auto',
			layout : 'hbox',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				itemId: 'basicdetail_FormSubmitButtonId',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				//  action: 'Submit',
				text: getCommonTranslation('ADD_MORE_DETAILS'),
				hidden:true,
				itemId: 'createform_addmorebuttonId',
				ui : 'CustomBtnThird',
				scale : CONSTANTS.BUTTONSIZE

			},{
				xtype: 'button',
				//width: 536,
				name: 'courseSyllabus',
				text:getCommonTranslation('UPLOAD_DOC'),
				itemId: 'uploadCourseItemId',
				ui: 'CustomBtnThird',
				cls:'CustomBtnSubmitToolbaar',
				scale : CONSTANTS.BUTTONSIZE
			}]
		}
	]
});
