/**
 * @author Prashant Choudhary
 */
Ext.define('Academia.view.course.coursegroup.uploaddownload.CourseGroupUploadForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.coursegroupuploadform',
	autoScroll: false,
	frame: false,
	cls: 'horizontalScrollingFixed',
	
	standardSubmit: false,
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	items: [{
		xtype: 'customcombobox',
		name: 'importUtilityMasterId',
		itemId:'moduleName',
		labelAlign: 'top',
		store:'importutility.ImportCourseGroupAssignCourses',
		fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
		valueField: 'id',
		displayField: 'value',
		typeAhead:true,
		forceSelection:false,
		allowBlank:false,
		listConfig: {
			  listeners: {
				  beforeshow: function(picker) {
					  var pickerComboVal = picker.up('combobox').value;
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
		}
		
	},{
		xtype : 'filefield',
		ui : 'CustomBtnThird',
		width: 536,
		fieldLabel : getCommonTranslation('UPLOAD_FILE'),
		buttonText : getCommonTranslation('BROWSE_FILE'),
		itemId : 'uploadFileField',
		name : 'file',
		allowBlank:false,
		validateOnChange : true,
		listeners:{
            change: function(fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
                    }
                }
            }
        }
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls CustomSearchPanelBtnLeftMargin',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getTranslation('UPLOAD_DATA'),
			formBind: true,
			itemId: 'uploadId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]});
