Ext.define('Academia.view.course.coursespecialization.history.ViewRelatedProgramGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.viewrelatedprogramgrid',
	store : ['Academia.store.course.coursespecialization.ViewStore'],
	border : true,
	//hidden:true,
    autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
            emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	} ],
	columns : [{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'program',
		sortable: true,
		flex :1
	}, {
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batch',
		sortable: true,
		flex : 1
	}, {
		header : getCommonTranslation('PRIMARY_ACADEMIC_YEAR'),
		dataIndex : 'academyYear',
		sortable: true,
		flex : 1
	}, {
		header : getCommonTranslation('COURSE_GROUP'),
		dataIndex : 'courseGroup',
		sortable: true,
		flex : 1
	}, {
		header : getCommonTranslation('ENROLL_REQUEST_RECIEVED')  ,
		dataIndex : 'enrollReqRecieved',
		sortable: true,
		flex : 1
	}, {
		header : getCommonTranslation('ENROLL_REQUEST_REJECTED'),
		dataIndex : 'courseGroup',
		sortable: true,
		flex : 1
	}, {
		header : getCommonTranslation('STUDENT_ENROLLED') ,
		dataIndex : 'enrollReqRecieved',
		sortable: true,
		flex : 1
	}, {
		header : getCommonTranslation('MIN_MAX_CREDITS'),
		dataIndex : 'courseGroup',
		sortable: true,
		flex : 1
	}]
});
