/**
 * @author Deepak S
 */
Ext.define('Academia.view.course.readingmaterial.readingmaterialinformation.MapCoursesPncForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.mapcoursespncform',
    //frame: true,
    border: false,
    autoScroll: true,
	layout:'anchor',
	cls:' panelNoSpace horizontalScrollingFixed x-form-fixed-footer-parent',
    itemId: 'mapcoursespncformItemId',
    items: [{
    	xtype:'panel',
    	layout: 'vbox',
    	width: '100%',
    	cls:'customSearchPanel',
    	items:[{
    		xtype: 'fieldcontainer',
    		layout: 'hbox',
    		defaults: {
    			labelAlign: 'top',
    			width: 256
    		},
    		items: [{
    			xtype: 'hidden',
    			name: 'id',
    			itemId: 'idItemId'
    		}, {
    			xtype: 'customcombobox',
    			fieldLabel: getCommonTranslation("ACADEMY_LOCATION"),
    			name: 'ACADEMY_LOCATION_ID',
    			itemId:'academyLocationCombo',
    			editable: true,
    			store: 'user.UserAcademyLocationStore',
    			displayField: 'value',
    			valueField: 'id',
    			width: 452,
    			minChars:3,
    			typeAhead:true,
    			forceSelection :true,
    			queryParam:'qry',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			}
    		}, {
    			xtype: 'customcombobox',
    			fieldLabel: getProgramandcourseTranslation('PC_COURSE_RESOURCE_TYPE'),
    			itemId: 'topicId',
    			name: 'TOPIC_READING_ID',
    			store:Ext.create('Academia.store.course.readingmaterial.ReadingTypeStore'),
    			valueField:'id',
    			displayField:'value',
    			allowBlank:true,
    			typeAhead:false,
    			forceSelection:true,
    			queryParam:'name',
    			minChars:3,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code} / {value}'  +
    					'</div>';
    				}
    			}

    		}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: 'hbox',
    		defaults: {
    			labelAlign: 'top',
    			width: 256
    		},
    		items: [{
    			xtype: 'customcombobox',
    			name: 'department',
    			itemId:'courseDepartment',
    			fieldLabel: getCommonTranslation('COURSE_DEPARTMENT'),			
    			store:Ext.create('Academia.store.course.DepartmentByALCourseStore'),
    			width: 452,
    			valueField: 'id',
    			displayField: 'value',
    			typeAhead:false,
    			forceSelection:true,
    			queryParam:'qry',
    			minChars:3,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    						picker.width = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}'+ 
    					'</div>';
    				}
    			}

    		}]
    	}, {
    		xtype: 'fieldcontainer',
    		width: '100%',
    		cls: 'customSearchPanelBtnsFieldContainerCls',
    		layout : {
    			type : 'hbox'
    		},
    		items: [{
    			xtype: 'button',
    			text: getCommonTranslation('SEARCH'),
    			itemId: 'searchBtn',
    			buttonAlign: 'left',
    			ui: 'CustomBtnSubmit',
    			scale: CONSTANTS.BUTTONSIZE,
    			formBind:true
    		},{
    			xtype: 'button',
    			text: getCommonTranslation('RESET'),
    			itemId: 'resetMapCourseItemId',
    			buttonAlign: 'left',
    			ui: 'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE
    		}]
    	},{
		//	html: '<b>Tip: Select and search to filter the Reading Name and Course in the grid.</b>',
			
    		html: '<b>'+getProgramandcourseTranslation('TIPS_PARA')+'</b>',
    		margin: 0,
			padding:0,
			width:'100%'
		}] 

    }, {
        xtype: 'mapcoursespncgrid',
        style: {
            marginLeft: '0px',
            marginTop: '30px'
        }
    }]
});