
Ext.define('Academia.view.course.requisite.CourseRequisiteFilter', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.courserequisitefilter',
    autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	style: {
		'max-height': '191px !important;'
	},
	standardSubmit : false,
	plugins : "formlabelrequired",
	items: [{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype : 'customcombobox',
			name : 'courseDepartment',
			itemId : 'courseDepartmentId',
			fieldLabel : getCommonTranslation('COURSE_DEPARTMENT'),
			store:Ext.create('Academia.store.course.UserAccessibleALCourseDepartmentStore'),
			valueField : 'id',
			displayField : 'value',
			minChars:3,
			forceSelection:true,
			style:{
				marginLeft:'05px'
			},
			queryParam:'name',
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'course',
			itemId: 'courseId',
			width: 536,
			store:Ext.create('Academia.store.course.UserAccessibleALChildCourseStore'),
			displayField: 'valueCode',
			valueField: 'id',
			fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
			allowBlank:false,
			minChars:3,
			forceSelection:true,
			style:{
				marginLeft:'05px'
			},
			queryParam:'courseName',
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype : 'displayfield',
			name : 'programBatch',
			itemId : 'programBatchItemId',
			fieldLabel : getProgramandcourseTranslation('PROGRAM_BATCH_NAME'),
			hidden:true
		},{
			xtype: 'displayfield',
			name:'courseCodeName',
			itemId: 'courseCodeNameItemId',
			fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
			hidden:true
		}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items:[{  
			xtype: 'button',
			itemId: 'searchBtn',
			formBind:true,
			text: getCourseTxCommonTranslation('SEARCH'),
			ui:'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			disabled : true
	     },{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCourseTxCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]	
	}]
});