/**
 * @author Vishal Joshi
 * 
 */
Ext.define('Academia.view.coursesessiondiary.CourseSessionDiaryFacultyPortalFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.coursesessiondiaryfacultyportalfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'vbox',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items :[{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'academicTerm',
				itemId : 'academicTerm',
				displayField : 'value',
				valueField : 'id',
				store:'common.AcademicTermStore',
				typeAhead : true,
				forceSelection : true,
				hidden : false,
				width: 256
			},{
				xtype: 'customcombobox',
				fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
				name:'COURSE_VARIENT_ID',
				itemId: 'courseVariantId',
				store:Ext.create('Academia.store.course.coursevariants.ParameterCourseVariantStore'),
				displayField: 'courseVariantCode',
				valueField: 'id',
				typeAhead:true,
				forceSelection:true,
				allowBlank:true,
				disabled:true
			}]
		},{
				xtype:'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					labelAlign:'top',
					width: 256
				},
				items:[{
					xtype: 'customcombobox',
					name:'programId',
					itemId:'programItemId',
					store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
					fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'name',
					minChars:3,
					width: 256,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		            listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                    '{code} / {value}'+
			                    '</div>';
			                }
			            }
				},{
					xtype: 'customcombobox',
					name:'batchId',
					itemId:'batchItemId',
					store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
					fieldLabel:getExaminationTranslation('BATCH'),
					valueField: 'id',
					displayField: 'value',
					width: 256,
					disabled:true,
					typeAhead : true,
					forceSelection : true,
					listConfig: {
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						},
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
					}
				},{
					xtype: 'customcombobox',
					name: 'periodId',
					itemId: 'periodItemId',
					disabled:true,
					store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
					fieldLabel:getExaminationTranslation('PERIOD'),
					valueField: 'id',
					displayField: 'value',
					width: 256,
					typeAhead : true,
					forceSelection : true,
					listConfig: {
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						},
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
					}
				}]

			},{
				xtype:'fieldcontainer',
				layout:'hbox',
				width: '100%',
				defaults: {
					width: 536,
					labelAlign: 'top'
				},
				items:[{
					xtype: 'customcombobox',
					name: 'sectionId',
					itemId: 'sectionItemId',
					disabled:true,
					store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
					fieldLabel:getExaminationTranslation('SECTION'),
					valueField: 'id',
					displayField: 'value',
					width: 256,
					typeAhead : true,
					forceSelection : true,
					listConfig: {
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						},
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
					}
				},{
					xtype : 'datefield',
					fieldLabel : getProgramandcourseTranslation('START_DATE'),
					name : 'startDate',
					itemId:'startDate',
					endDateField : 'endDate',
					//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype : 'daterange',
					width: 256,
					maxValue:new Date(),
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					}
				},{
					xtype : 'datefield',
					fieldLabel :getProgramandcourseTranslation('END_DATE'),
					name : 'endDate',
					itemId : 'endDate',
					startDateField : 'startDate',
					//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype : 'daterange',
					width: 256,
					maxValue:new Date(),
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					}
				}]
			}],
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'courseSessionDiarySearchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'courseSessionDiaryResetBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});
