Ext.define('Academia.view.coursetransaction.coursereading.AssignCoursesList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.assigncourseslist',
	store : 'coursetransaction.coursereading.AssignCourseGrid',
	title : getCommonTranslation("RESOURCE_REQUEST_DETAILS"),
	border: true,
	autoScroll: false,
	frame: false,
	style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		deferEmptyText: false,
        emptyText: getCommonTranslation('NORESULTSNMESSAGE')
	},
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	/*dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			store : 'coursetransaction.coursereading.AssignCourseGrid',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],*/
	tbar: [{
		xtype: 'button',
		itemId: 'assignCourse_Add_Id',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},/*{
		xtype : 'button',				
		itemId : 'assignCourse_Delete_Id',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		disabled:true,
		glyph: ICONGLYPH.DELETEGLYPH
	},*/{
		xtype: 'customcombobox',
		name : 'academicTerm',
		itemId : 'academicTerm',
		labelAlign : 'left',
		fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
		store: Ext.create('Academia.store.course.readingmaterial.ReadingMaterialAcademicTerm'),
		valueField: 'id',
		displayField: 'value',
		width:326,
		hidden:true,
		typeAhead : true,
		editable : false
		
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		hidden:true,
		scale: CONSTANTS.BUTTONSIZE
	},{	
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls:'windowBtnPos',
		itemId: 'fldContCVSaveItemId',
		hidden:true,
		defaults: {
			labelAlign:'top',
		},
		items:[{
			xtype: 'button',
			itemId: 'btnSaveMapCourseVarItemId',
			disabled:true,
			tooltip: getExaminationTranslation('SAVE'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			text:getExaminationTranslation('SAVE')
		}]
	}],
	columns : [/*{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyName',
		flex:1,
		sortable : true
	}*/{
        header: getCommonTranslation('ACADEMIC_TERM'),
        dataIndex: 'academicTermId',
        flex: 1,
        sortable: true,
        editor: {
			xtype : 'customcombobox',
			name : 'academicTermId',
			itemId : 'academicTermId',
			displayField : 'value',
			store:Ext.create('Academia.store.course.readingmaterial.ReadingMaterialAcademicTerm'),
			valueField : 'id',
			typeAhead : true,
			editable : false,
			listeners: {
				select: function(combo, record) {
					var grid = combo.up('assigncourseslist');
					var selectedRecord = grid.getSelectionModel().getSelection()[0];

					if(!isNullOrEmpty(selectedRecord.data.id)){
						var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

					}else{
						var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
					}
					var editPlugin = this.up().editingPlugin;
					var curCol = editPlugin.context.colIdx;
					var rowIdx = editPlugin.context.rowIdx;
					var nextcolumnEditor = editPlugin.activeColumn.nextNode().getEditor();

					var models = grid.getStore().getRange();
					if(!isNullOrEmpty(nextcolumnEditor)){
						models[rowIdx].set("courseId", null);
						models[rowIdx].set("courseReadingId", null);
						models[rowIdx].set("courseVariantCode", null);
						nextcolumnEditor.setValue(null);
					}
				}
			}
		},
		listeners: {
			render: function(combo){
				var me = this;
        		var assigncourseslist = combo.up('assigncourseslist');
				var academyLocationId = assigncourseslist.config.academyLocationId;
				var readingId = assigncourseslist.config.readingId;
				if(!isNullOrEmpty(combo)){
					combo.getEditor().store.on('beforeload', function(){
    					this.getProxy().extraParams = {
    						academyLocationIds: academyLocationId,
    						readingNameId:readingId
    					};
    				});
					combo.getEditor().store.load();
				}
			}
    	},
    	renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if(!isNullOrEmpty(value) && value !== '') {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
    				}else{
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(Ext.isDefined(record.get('academicTermId')) && isNullOrEmpty(record.get('academicTermId'))){
    				rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
    			else{
    				var editor = rec.column.getEditor();
    				var recTypeName = record.get('academicTermId');
    				editor.store.load();
    				if(!isNullOrEmpty(recTypeName)){
    					return recTypeName;
    				}else{
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    		}
    	}
    },{
        header: getCommonTranslation('COURSE_CODE_NAME'),
        dataIndex: 'courseId',
        flex: 1,
        sortable: true,
        editor: {
        	xtype: 'customcombobox',
        	itemId: 'courseId',
        	name: 'COURSE', 
        	store:Ext.create('Academia.store.course.LinkedCourseWithReadingNameStore'),
        	valueField:'id',
        	displayField:'value',
        	typeAhead:false,
        	forceSelection:true,
        	queryParam:'courseName',
        	minChars:3,
        	triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        	enableKeyEvents  : 'true',
        	hideTrigger:false,
        	forceSelection:true,
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{code} / {value}'  +
        			'</div>';
        		}
        	},
        	listeners: {
        		select: function(combo, record) {
        			var grid = combo.up('assigncourseslist');
        			var selectedRecord = grid.getSelectionModel().getSelection()[0];
        			var idVal = record[0].data.id;
        			var codeVal = record[0].data.code;
        			var courseVariantCode = record[0].data.courseVariantCode;
        			
        			var editPlugin = this.up().editingPlugin;
					var curCol = editPlugin.context.colIdx;
					var rowIdx = editPlugin.context.rowIdx;
					var nextcolumnEditor = editPlugin.activeColumn.nextNode().getEditor();
        			
        			var models = grid.getStore().getRange();
					if(!isNullOrEmpty(nextcolumnEditor)){
						models[rowIdx].set("courseVariantCode", null);
						nextcolumnEditor.setValue(null);
					}

        			if(!isNullOrEmpty(selectedRecord.data.id)){
        				var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

        			}else{
        				var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
        			}
        			//recordToBeUpdated.set('courseId','');
        			var flag = true;
        			var itms = grid.getStore().data.items;
        			itms.forEach(function(object){
        				if(object.data.academicTermId  == recordToBeUpdated.data.academicTermId && object.data.courseId == record[0].data.id){
        					flag = false;
        					return false;
        				}
        			});
        			if(flag){
        				if(!isNullOrEmpty(selectedRecord.data.id)){
        					var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

        				}else{
        					var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
        				}

        				if(!isNullOrEmpty(idVal)){
        					var editPlugin = this.up().editingPlugin;
        					var curCol = editPlugin.context.colIdx;
        					var rowIdx = editPlugin.context.rowIdx;
        					Ext.Ajax.request({
        						type : 'rest',
        						url : SERVERURL.PATH_GET_ACTIVE_COURSE_DEPARTMENT,
        						params : {
        							courseId : idVal
        						},
        						method : 'GET',
        						success : function(response) {
        							var models = grid.getStore().getRange();
        							if(!isNullOrEmpty(response.responseText)){
        								var resp = Ext.decode(response.responseText);
        								models[rowIdx].set("courseDepartment", resp[0].value);
        								models[rowIdx].set("courseId", idVal);
        								models[rowIdx].set("courseReadingId", codeVal);
        								models[rowIdx].set("courseVariantId", courseVariantCode);
        							}
        						}
        					});
        				}
        				//recordToBeUpdated.set('readingName',record.data.id);
        			}else{
        				combo.reset();
        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('COURSE_ALREADY_SELECTED_MSG'));
        				return false;
        			}
        		},
    			blur: function(combo, r) {
    				var grid = combo.up('grid');
    				combo.getStore().on('beforeload', function(){
    					var selectedRecord = grid.getSelectionModel().getSelection()[0];

    					if (!selectedRecord) return;

    					var academicTermId = selectedRecord.data.academicTermId;

    					this.getProxy().setExtraParam('academicTermId', academicTermId);
    				});
    				combo.getStore().load();
    			},
    			focus: function(combo, e, eOpts) {
    				var grid = combo.up('assigncourseslist');
    				var selectionModel = grid.getSelectionModel().getSelection();
    				var academicTermId = null;
    				if(selectionModel.length>0){
    					academicTermId = selectionModel[0].data.academicTermId;
    				}
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().setExtraParam('academicTermId', academicTermId);
    				});
    				combo.getStore().load();
    			}
    		}
        },
        listeners: {
			render: function(combo){
				var me = this;
        		var assigncourseslist = combo.up('assigncourseslist');
				var readingId = assigncourseslist.config.readingId;
				
				if(!isNullOrEmpty(combo)){
					combo.getEditor().store.on('beforeload', function(){
    					this.getProxy().extraParams = {
    						readingId: readingId
    					};
    				});
					combo.getEditor().store.load();
				}
			}
    	},
    	renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if(!isNullOrEmpty(value) && value !== '') {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
    				}else{
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(Ext.isDefined(record.get('courseId')) && isNullOrEmpty(record.get('courseId'))){
    				rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
    			else{
    				var editor = rec.column.getEditor();
    				var recTypeName = record.get('courseId');
    				editor.store.load();
    				if(!isNullOrEmpty(recTypeName)){
    					return recTypeName;
    				}
    			}
    		}
    	}
    },{
    	header: getProgramandcourseTranslation('COURSE_VARIANT'),
    	dataIndex: 'courseVariantId',
    	flex: 1,
    	sortable: true,
    	editor: {
    		xtype : 'customcombobox',
    		name : 'courseVariantCode',
    		itemId : 'courseVariant',
    		queryParam:'courseVariantId',
    		displayField: 'value',
    		valueField: 'id',
    		store:Ext.create('Academia.store.course.coursevariants.ChildCourseVariantByAcademicTermStore'),
    		typeAhead : true,
    		editable : false,
    		listeners: {
    			select: function(combo, record) {
    				var grid = combo.up('assigncourseslist');
    				var selectedRecord = grid.getSelectionModel().getSelection()[0];
    				
    				if (selectedRecord && record[0]) {
    					selectedRecord.set('courseVariantId', record[0].get('id'));
    					selectedRecord.set('courseVariantCode', record[0].get('value'));
    				}
    			},
    			focus: function(combo) {
    	            var grid = combo.up('assigncourseslist');
    	            var selectedRecord = grid.getSelectionModel().getSelection()[0];

    	            if (!selectedRecord) return;

    	            var academicTermId = selectedRecord.get('academicTermId');
    	            var courseId = selectedRecord.get('courseId');
    	            var academyLocationId = grid.config.academyLocationId;

    	            if (!Ext.isEmpty(courseId) && !Ext.isEmpty(academicTermId)) {
    	                var store = combo.getStore();
    	                store.getProxy().extraParams = {
    	                    academyLocationIds: academyLocationId,
    	                    academicTermId: academicTermId,
    	                    courseId: courseId
    	                };
    	                store.load();
    	            }
    	        }
    		}
    	},
			renderer: function (value, rec, record, rowIndex, colIndex, store, view) {
				var colVal = record.get('courseVariantCode');

				if (isNullOrEmpty(colVal)) {
					rec.tdCls = 'gridInputCustomStyle';

					return getExaminationTranslation('CLICK_TO_ENTER');
				}

				return colVal;
    	}
    },{
		header : getCommonTranslation('COURSE_DEPARTMENT'),
		dataIndex : 'courseDepartment',
		flex:1,
		sortable : true,
    	renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if(!isNullOrEmpty(value) && value !== '') {
    			return value;
    		}
    	}
	},{
        header: getCommonTranslation('DATE_REQUIRED'),
        dataIndex: 'dateRequired',
        flex: 1,
        sortable: true,
        editor: {
            xtype: 'datefield',
            name: 'dateRequired',
            minValue:new Date(),
            itemId: 'dateRequiredId',
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        	var dateVal = dateRender(val);
        	if(dateVal == "NaN-NaN-0NaN"){
        		return val;	
        	}else if(!isNullOrEmpty(val)){
        		var date = moment(val, "DD/MM/YYYY").format("DD-MM-Y");
        		if(date == "Invalid date"){
        			date = moment(val, "MM/DD/YYYY").format("DD-MM-Y");
        		}
        		return date;
        	}
        	else{
        		rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
			}
        	/*var grid = view.up();
            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.dateRequired)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var store = grid.getStore();
                var models = grid.getStore().getRange();
                if (!isNullOrEmpty(val)) {

                } else if (!isNullOrEmpty(record.data.dateRequired)) {
                    val = record.data.dateRequired;
                }
                models[rowIndex].set("dateRequired", val);
                return dateRender(val);
            }*/
            
        	/*var dateVal = dateRender(val);
        	if(dateVal == "NaN-NaN-0NaN"){
        		return val;	
        	}else if(!isNullOrEmpty(val)){
        		return dateRender(val);
        	}
        	else{
        		if(!isNullOrEmpty(record.modified.dateRequired)){
        			var grid = view.up();
        			var store = grid.getStore();
        			var models = grid.getStore().getRange();
        			var editor = rec.column.getEditor();
        			editor.setValue(record.modified.dateRequired);
        			return dateRender(record.modified.dateRequired);
        		}
        	}*/
        	
        }
    },{
        header: getCommonTranslation('USER_REQUESTED_BY'),
        dataIndex: 'userRequestedId',
        flex: 1,
        sortable: true,
        editor: {
			xtype: 'customcombobox',
			name:'userRequestedId',
			store: 'common.AllUserBySmartSearch',
			valueField: 'id',
			displayField: 'value',
			queryParam:'codeOrName',
			minChars:3,
			typeAhead:false,
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents  : 'true',
            hideTrigger:false,
            //cls:'gridInputCustomStyle',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
		},
        listeners: {
			render: function(combo){
				var me = this;
				if(!isNullOrEmpty(combo)){
					combo.getEditor().store.on('beforeload', function(){
    					/*this.getProxy().extraParams = {
    						academyLocationId: academyLocationId
    					};*/
    				});
					combo.getEditor().store.load();
				}
			}
    	},
    	renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if(!isNullOrEmpty(value) && value !== '') {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
    				}else{
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(Ext.isDefined(record.get('userRequestedId')) && isNullOrEmpty(record.get('userRequestedId'))){
    				rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
    			else{
    				var editor = rec.column.getEditor();
    				var recTypeName = record.get('userRequestedId');
    				editor.store.load();
    				if(!isNullOrEmpty(recTypeName)){
    					return recTypeName;
    				}
    			}
    		}
    	}
    },{
        header: getCommonTranslation('NUMBER_ISSUED'),
        dataIndex: 'issuedNumber',
        flex: 1,
        sortable: true,
        editor: {
            xtype: 'numberfield',
            name: 'issuedNumber',
            itemId: 'issuedNumberId',
            maxLength: 10,
            minValue:0,
            allowExponential:false,
			keyNavEnabled: false,
			hideTrigger: true,
			mouseWheelEnabled:false,
			allowDecimals:false
        },
        renderer: function(val, rec) {
            if (isNullOrEmpty(val)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
    }, {
        header: getServiceRequestTranslation('EMM_ADD'),
        dataIndex: 'addButton',
        flex: 0.5,
        cls: 'CustomBodyBtnSettings',
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow)
                return "<div class='addButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            return '';
        }
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        flex: 0.6,
        cls: 'CustomBodyBtnSettings',
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
                return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            }
            return '';
        }
    }/*{
		header : getCommonTranslation('READING_NAME_ISBN'),
		dataIndex : 'courseReadingName',
		flex:1,
		sortable : true
	},{
		header :getCommonTranslation('COURSE_CODE_NAME'),
		dataIndex : 'courseName',
		flex:1,
		sortable : true
	},{
		header : getCourseTxCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantName',
		flex:1,
		sortable : true
	},*/],
    plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
            beforeedit: function(editor, context) {
            	 if(editor.context.field=='courseId'){
         			if(!isNullOrEmpty(context.record.data.academicTermId)){
         				context.grid.columns[1].getEditor().setReadOnly(false);
         				return context.colIdx !== 0;
         			}else{
         				context.grid.columns[1].getEditor().setReadOnly(true);
         			}
         		}
        	}
        }
    }]

});
