/**
 *  @author Rajkumar.patidar
 */

Ext.define('Academia.view.coursetransaction.facultyTopicAssignment.CourseSectionFTAGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.coursesectionftagrid',
	store : 'coursetransaction.facultytopicassignment.CSTopicStore',
	border: true,
	autoScroll: true,
	selType:'checkboxmodel',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'coursetransaction.facultytopicassignment.CSTopicStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        text:getCourseTxCommonTranslation('ASSIGN_FACULTY'),
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }],
	columns: [{
		header : getCourseTxCommonTranslation('TOPICS'),
		dataIndex : 'topic',
		flex:1,
		renderer:function(value){
			if(value!=null){
				return value.value;	
			}
		}
	},{
		header : getCourseTxCommonTranslation('NO_OF_SESSION'),
		dataIndex : 'noOfSessions',
		flex:1
	},{
		header : getCourseTxCommonTranslation('ASSIGN_FACULTY_1'),
		dataIndex : 'faculty',
		flex:1,
		renderer:function(value){
			if(value!=null){
				for(var i=0;i<value.length;i++){
					if(value[i].facultyAssignSequence==0){
						return value[i].facultyName;	
						break;
					}
				}
			}
		}
	},{	
		header : getCourseTxCommonTranslation('ALTERNATE_FACULTY'),
		dataIndex : 'alternateFaculty1',
		dataIndex : 'faculty',
		flex:1,
		renderer:function(value){
			if(value!=null){
				for(var i=0;i<value.length;i++){
					if(value[i].facultyAssignSequence==0){
						return value[i].alternateFacultyName;	
						break;
					}
				}
			}
		}
	},{
		header : getCourseTxCommonTranslation('ASSIGN_FACULTY_2'),
		dataIndex : 'faculty',
		flex:1,
		renderer:function(value){
			if(value!=null){
				for(var i=0;i<value.length;i++){
					if(value[i].facultyAssignSequence==1){
						return value[i].facultyName;	
						break;
					}
				}
			}
		}
	},{
	header : getCourseTxCommonTranslation('ALTERNATE_FACULTY'),
	dataIndex : 'alternateFaculty2',
	dataIndex : 'faculty',
	flex:1,
	renderer:function(value){
		if(value!=null){
			for(var i=0;i<value.length;i++){
				if(value[i].facultyAssignSequence==1){
					return value[i].alternateFacultyName;	
					break;
				}
			}
		}
	}
	},{
		header : getCourseTxCommonTranslation('ASSIGN_FACULTY_3'),
		dataIndex : 'faculty',
		flex:1,
		renderer:function(value){
			if(value!=null){
				for(var i=0;i<value.length;i++){
					if(value[i].facultyAssignSequence==2){
						return value[i].facultyName;	
						break;
					}
				}
			}
		}
	},{
		header : getCourseTxCommonTranslation('ALTERNATE_FACULTY'),
		dataIndex : 'alternateFaculty3',
		dataIndex : 'faculty',
		flex:1,
		renderer:function(value){
			if(value!=null){
				for(var i=0;i<value.length;i++){
					if(value[i].facultyAssignSequence==2){
						return value[i].alternateFacultyName;	
						break;
					}
				}
			}
		}
	}]
});